package an0nym8us.bukkit.magicCrafting.managers;

import java.io.File;
import java.lang.reflect.Field;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

import com.comphenix.protocol.wrappers.EnumWrappers.Particle;

import an0nym8us.bukkit.magicCrafting.Independent;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.altar.AltarStructure;

public class ConfigManager
{
	@Independent
	FileConfiguration config;

	String language = "default";
	
	String borderParticle = "flame";
	String successParticle = "explode";
	String failParticle = "hugeExplosion";
	String failSound = "random.explode";
	
	boolean ownershipChecking = false;
	boolean preloadMinecraftRecipes = true;
	boolean createNewRecipeIfDeleted = true;
	boolean enableVaultService = true;
	boolean enableNamedRecipePermissions = true;
	boolean removeStructuresOnPlayerQuit = true;
	boolean structureEnvironmentalDestroy = true;
	boolean enableBrewingCauldron = false;

	int altarCenterMaterial = 152;
	int altarFirstMaterial = 57;
	int altarSecondMaterial = 133;
	int altarResultMaterial = 152;
	int brewingTime = 160;
	int maxAltarLevel = 2;
	int maxAltarsPerPlayer = 0;
	int maxCauldronsPerPlayer = 0;
	
	int fileSavingPeriod = 2400;
	
	boolean mysql_enabled = false;
	String mysql_userName = "root";
	String mysql_database = "db";
	String mysql_password = "1234";
	int mysql_port = 3306;
	String mysql_hostname = "127.0.0.1";

	public ConfigManager()
	{
		config = Main.GetInstance().getConfig();

		Load();
		
		LoadEffects();
		
		LoadMaterials();
	}

	private void Load()
	{
		Field[] fields = this.getClass().getDeclaredFields();

		for (Field f : fields)
		{
			if (f.isAnnotationPresent(Independent.class))
			{
				continue;
			}

			try
			{
				f.setAccessible(true);

				config.addDefault(f.getName().replace('_', '.'), f.get(this));
			}
			catch (IllegalArgumentException e)
			{
				e.printStackTrace();
			}
			catch (IllegalAccessException e)
			{
				e.printStackTrace();
			}
		}

		config.options().copyDefaults(true);
		Main.GetInstance().saveConfig();

		for (Field f : fields)
		{
			if (f.isAnnotationPresent(Independent.class))
			{
				continue;
			}

			try
			{
				f.setAccessible(true);

				f.set(this, config.get(f.getName().replace('_', '.')));
			}
			catch (IllegalArgumentException e)
			{
				e.printStackTrace();
			}
			catch (IllegalAccessException e)
			{
				e.printStackTrace();
			}
		}
	}
	
	protected void LoadEffects()
	{
		try
		{
			Field f = AltarStructure.class.getDeclaredField("BORDER_PARTICLE");
			Particle p = Particle.getByName(borderParticle);
			
			if(p != null)
			{
				f.setAccessible(true);
				f.set(null, p);
			}
			else
			{
				Bukkit.getLogger().warning("Particle not found: " + borderParticle);
			}
			
			f = AltarStructure.class.getDeclaredField("SUCCESS_PARTICLE");
			p = Particle.getByName(successParticle);
			
			if(p != null)
			{
				f.setAccessible(true);
				f.set(null, p);
			}
			else
			{
				Bukkit.getLogger().warning("Particle not found: " + successParticle);
			}
			
			f = AltarStructure.class.getDeclaredField("FAIL_PARTICLE");
			p = Particle.getByName(failParticle);
			
			if(p != null)
			{
				f.setAccessible(true);
				f.set(null, p);
			}
			else
			{
				Bukkit.getLogger().warning("Particle not found: " + failParticle);
			}
			
			f = AltarStructure.class.getDeclaredField("FAIL_SOUND");
			
			f.setAccessible(true);
			f.set(null, failSound);
		}
		catch(Throwable t)
		{
			Bukkit.getLogger().warning("Could not load all particle and sound effect!");
		}
	}
	
	@SuppressWarnings("deprecation")
	protected void LoadMaterials()
	{
		try
		{
			Field f = AltarStructure.class.getDeclaredField("CENTER_MAT");
			Material m = Material.getMaterial(altarCenterMaterial);
			
			if(m != null)
			{
				f.setAccessible(true);
				f.set(null, m);
			}
			else
			{
				Bukkit.getLogger().warning("Material not found: " + altarCenterMaterial);
			}
			
			f = AltarStructure.class.getDeclaredField("FIRST_MAT");
			m = Material.getMaterial(altarFirstMaterial);
			
			if(m != null)
			{
				f.setAccessible(true);
				f.set(null, m);
			}
			else
			{
				Bukkit.getLogger().warning("Material not found: " + altarFirstMaterial);
			}
			
			f = AltarStructure.class.getDeclaredField("SECOND_MAT");
			m = Material.getMaterial(altarSecondMaterial);
			
			if(m != null)
			{
				f.setAccessible(true);
				f.set(null, m);
			}
			else
			{
				Bukkit.getLogger().warning("Material not found: " + altarSecondMaterial);
			}
			
			f = AltarStructure.class.getDeclaredField("RESULT_MAT");
			m = Material.getMaterial(altarResultMaterial);
			
			if(m != null)
			{
				f.setAccessible(true);
				f.set(null, m);
			}
			else
			{
				Bukkit.getLogger().warning("Material not found: " + altarResultMaterial);
			}
			
			
		}
		catch(Throwable t)
		{
			Bukkit.getLogger().warning("Could not load all particle and sound effect!");
		}
	}

	public String GetLanguagePath()
	{
		return "languages\\" + language + ".yml";
	}
	
	public File GetLanguageFile()
	{
		File f = new File(Main.GetInstance().getDataFolder(), GetLanguagePath());
		
		return f;
	}
	
	public boolean isAltarOwnershipChecking()
	{
		return ownershipChecking;
	}

	public boolean isPreloadMinecraftRecipes()
	{
		return preloadMinecraftRecipes;
	}

	public boolean isCreateNewRecipeIfDeleted()
	{
		return createNewRecipeIfDeleted;
	}
	
	public boolean isEnableVaultService()
	{
		return enableVaultService;
	}
	
	public boolean isEnableNamedRecipePermissions()
	{
		return enableNamedRecipePermissions;
	}
	
	public boolean isRemoveStructuresOnPlayerQuit()
	{
		return removeStructuresOnPlayerQuit;
	}
	
	public boolean isStructureEnvironmentalDestroy()
	{
		return structureEnvironmentalDestroy;
	}

	@SuppressWarnings("deprecation")
	public Material getAltarCenterMaterial()
	{
		return Material.getMaterial(altarCenterMaterial);
	}

	@SuppressWarnings("deprecation")
	public Material getAltarFirstMaterial()
	{
		return Material.getMaterial(altarFirstMaterial);
	}

	@SuppressWarnings("deprecation")
	public Material getAltarSecondMaterial()
	{
		return Material.getMaterial(altarSecondMaterial);
	}

	@SuppressWarnings("deprecation")
	public Material getAltarResultMaterial()
	{
		return Material.getMaterial(altarResultMaterial);
	}

	public String getSuccessParticle()
	{
		return successParticle;
	}

	public String getFailParticle()
	{
		return failParticle;
	}

	public String getFailSound()
	{
		return failSound;
	}
	
	public int getBrewingTime()
	{
		return brewingTime;
	}
	
	public int getMaxAltarLevel()
	{
		return maxAltarLevel;
	}

	public int getMaxAltarsPerPlayer()
	{
		return maxAltarsPerPlayer > 0 ? maxAltarsPerPlayer : Integer.MAX_VALUE;
	}

	public int getMaxCauldronsPerPlayer()
	{
		return maxCauldronsPerPlayer > 0 ? maxCauldronsPerPlayer : Integer.MAX_VALUE;
	}

	public boolean isEnableBrewingCauldron()
	{
		return enableBrewingCauldron;
	}

	public boolean isOwnershipChecking()
	{
		return ownershipChecking;
	}
	
	public int getFileSavingPeriod()
	{
		return fileSavingPeriod;
	}
	
	public boolean isMysqlEnabled()
	{
		return mysql_enabled;
	}

	public String getMysqlUserName()
	{
		return mysql_userName;
	}

	public String getMysqlDatabase()
	{
		return mysql_database;
	}

	public String getMysqlPassword()
	{
		return mysql_password;
	}

	public int getMysqlPort()
	{
		return mysql_port;
	}

	public String getMysqlHostname()
	{
		return mysql_hostname;
	}
}
