package an0nym8us.bukkit.magicCrafting.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.EnumWrappers.EntityUseAction;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.altar.IStructure;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;

public class StructureListener extends PacketAdapter implements Listener
{
	public static final long DELAY = 150;

	Map<UUID, Long> timings = new HashMap<UUID, Long>();
	List<IStructureListenerHandler> handlers = new ArrayList<IStructureListenerHandler>();
	
	public StructureListener()
	{
		super(Main.GetInstance(), PacketType.Play.Client.USE_ENTITY);
		
		handlers.add(new ItemArraySLH());
		handlers.add(new AltarSLH());
	}
	
	boolean VerifyDelay(UUID uuid, long currentTiming)
	{
		Long timing = timings.get(uuid);

		if (timing == null || currentTiming - timing >= DELAY)
		{
			timings.put(uuid, currentTiming);
			
			return true;
		}
		
		return false;
	}
	
	protected boolean CallHandlers(Player player, Block clickedBlock, boolean isLeftClick)
	{
		for(IStructureListenerHandler handler : handlers)
		{
			if(handler.Handle(player, clickedBlock, isLeftClick))
			{
				return true;
			}
		}
		
		return false;
	}

	@Override
	public void onPacketReceiving(PacketEvent ev)
	{
		if (!VerifyDelay(ev.getPlayer().getUniqueId(), System.currentTimeMillis())) { return; }
		
		PacketContainer pc = ev.getPacket();

		Block b = ev.getPlayer().getTargetBlock((Set<Material>) null, 5);

		if (b == null) { return; }
		
		if(CallHandlers(ev.getPlayer(), b, pc.getEntityUseActions().read(0).equals(EntityUseAction.ATTACK)))
		{
			ev.setCancelled(true);
		}
	}

	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if (!VerifyDelay(ev.getPlayer().getUniqueId(), System.currentTimeMillis())) { return; }

		if (ev.getAction().equals(Action.RIGHT_CLICK_BLOCK))
		{
			if(CallHandlers(ev.getPlayer(), ev.getClickedBlock(), false))
			{
				ev.setCancelled(true);
			}
		}
		else if (ev.getAction().equals(Action.LEFT_CLICK_BLOCK))
		{
			if(CallHandlers(ev.getPlayer(), ev.getClickedBlock(), true))
			{
				ev.setCancelled(true);
			}
		}
	}

	@EventHandler
	public void onBlockBreak(BlockBreakEvent ev)
	{
		if (Main.GetInstance().GetStructureManager().GetStructure(ev.getBlock().getLocation()) != null)
		{
			ev.setCancelled(true);
		}
	}

	@EventHandler
	public void onExplosionPrime(EntityExplodeEvent ev)
	{
		for (Block b : ev.blockList())
		{
			IStructure structure = Main.GetInstance().GetStructureManager().GetStructure(b.getLocation());

			if (structure == null)
			{
				continue;
			}

			if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
			{
				RemoveStruct(null, structure);
			}
			else
			{
				ev.setCancelled(true);

				return;
			}
		}
	}

	@EventHandler
	public void onBlockBurn(BlockBurnEvent ev)
	{
		IStructure structure = Main.GetInstance().GetStructureManager().GetStructure(ev.getBlock().getLocation());

		if (structure == null) { return; }

		if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
		{
			RemoveStruct(null, structure);
		}
		else
		{
			ev.setCancelled(true);

			return;
		}
	}

	@EventHandler
	public void onBlockFade(BlockFadeEvent ev)
	{
		IStructure structure = Main.GetInstance().GetStructureManager().GetStructure(ev.getBlock().getLocation());

		if (structure == null) { return; }

		if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
		{
			RemoveStruct(null, structure);
		}
		else
		{
			ev.setCancelled(true);

			return;
		}
	}

	@EventHandler
	public void onPistonExtend(BlockPistonExtendEvent ev)
	{
		for (Block b : ev.getBlocks())
		{
			IStructure structure = Main.GetInstance().GetStructureManager().GetStructure(b.getLocation());

			if (structure == null)
			{
				continue;
			}

			if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
			{
				RemoveStruct(null, structure);
			}
			else
			{
				ev.setCancelled(true);

				return;
			}
		}
	}

	@EventHandler
	public void onPistonRetract(BlockPistonRetractEvent ev)
	{
		if (!ev.isSticky()) { return; }

		for (Block b : ev.getBlocks())
		{
			IStructure structure = Main.GetInstance().GetStructureManager().GetStructure(b.getLocation());

			if (structure == null)
			{
				continue;
			}

			if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
			{
				RemoveStruct(null, structure);
			}
			else
			{
				ev.setCancelled(true);

				return;
			}
		}
	}

	private void RemoveStruct(Player p, IStructure as)
	{
		if (as != null)
		{
			Main.GetInstance().GetStructureManager().RemoveStructure(as);

			if (p != null)
			{
				p.sendMessage(LanguageManager.GetText("altar.destroyed"));
			}
		}
	}
}
