package an0nym8us.bukkit.magicCrafting.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.brewing.BrewingStructure;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;

@SuppressWarnings("deprecation")
public class BrewingListener implements Listener
{
	public static final long DELAY = 150;

	Map<UUID, Long> timings = new HashMap<UUID, Long>();

	boolean VerifyDelay(UUID uuid, long currentTiming)
	{
		Long timing = timings.get(uuid);

		if (timing == null || currentTiming - timing >= DELAY)
		{
			timings.put(uuid, currentTiming);

			return true;
		}

		return false;
	}

	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if (!VerifyDelay(ev.getPlayer().getUniqueId(), System.currentTimeMillis())) { return; }

		if (ev.getAction().equals(Action.RIGHT_CLICK_BLOCK))
		{
			if (ev.getPlayer().getItemInHand() != null && ev.getPlayer().getItemInHand().getType().equals(Material.WATER_BUCKET)) { return; }

			if (!Main.GetInstance().GetBrewingManager().StructureExist(ev.getClickedBlock().getLocation()) && ev.getClickedBlock().getType().equals(Material.CAULDRON))
			{
				ev.setCancelled(true);

				ev.getPlayer().updateInventory();

				if (!ev.getPlayer().hasPermission("magicAspect.crafting.create.cauldron"))
				{
					ev.getPlayer().sendMessage(LanguageManager.GetText("cauldron.create.noPermission"));

					return;
				}
				else if (Main.GetInstance().GetBrewingManager().GetMaxStructureAmount(ev.getPlayer().getUniqueId()) <= Main.GetInstance().GetBrewingManager().GetStructureAmount(ev.getPlayer().getUniqueId()))
				{
					ev.getPlayer().sendMessage(LanguageManager.GetText("cauldron.maxReached"));

					return;
				}

				Main.GetInstance().GetBrewingManager().AddBrewingStructure(ev.getClickedBlock().getLocation(), ev.getPlayer().getUniqueId());

				return;
			}

			if (Main.GetInstance().GetBrewingManager().StructureExist(ev.getClickedBlock().getLocation()) && Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetTicks() == 0)
			{
				ev.setCancelled(true);

				BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation());

				if (!ev.getPlayer().hasPermission("magicAspect.crafting.bypassOwnership") && Main.GetInstance().GetConfigManager().isAltarOwnershipChecking() && !ev.getPlayer().getUniqueId().equals(bs.GetOwner())) { return; }

				if (bs.GetItemIn() != null && !bs.GetItemIn().getType().equals(Material.AIR))
				{
					if (bs.GetItemIn().getType().equals(Material.POTION))
					{
						if (ev.getPlayer().getItemInHand() != null && ev.getPlayer().getItemInHand().getType().equals(Material.GLASS_BOTTLE))
						{
							if (!bs.DecreaseCauldronLevel()) { return; }

							if (ev.getPlayer().getItemInHand().getAmount() > 1)
							{
								ev.getPlayer().getItemInHand().setAmount(ev.getPlayer().getItemInHand().getAmount() - 1);
							}
							else if (ev.getPlayer().getItemInHand().getAmount() > 0)
							{
								ev.getPlayer().getItemInHand().setType(Material.AIR);
							}
							else // In case whether glass bottle's itemstack has
									// negative amount
							{
								bs.IncreaseCauldronLevel();

								return;
							}

							if (ev.getPlayer().getInventory().firstEmpty() == -1)
							{
								ev.getPlayer().getWorld().dropItem(Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetLocation().clone().add(0, 2, 0), Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetItemIn());
							}
							else
							{
								ev.getPlayer().getInventory().addItem(Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetItemIn());
							}

							if (bs.GetCauldronLevel() <= 0)
							{
								Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).Clear();
							}
						}
					}
					else
					{
						if (ev.getPlayer().getInventory().firstEmpty() == -1)
						{
							ev.getPlayer().getWorld().dropItem(Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetLocation().clone().add(0, 2, 0), Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetItemIn());

							Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).Clear();
						}
						else
						{
							ev.getPlayer().getInventory().addItem(Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).GetItemIn());

							Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()).Clear();
						}
					}

					ev.getPlayer().updateInventory();
				}
				else if (ev.getPlayer().isSneaking())
				{
					Main.GetInstance().GetBrewingManager().RemoveStructure(Main.GetInstance().GetBrewingManager().GetStructure(ev.getClickedBlock().getLocation()));
				}
			}
		}
	}

	@EventHandler
	public void onExplosionPrime(EntityExplodeEvent ev)
	{
		for (int i = 0; i < ev.blockList().size(); i++)
		{
			BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(ev.blockList().get(i).getLocation());

			if (bs != null)
			{
				if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
				{
					RemoveStruct(null, bs);
				}
				else
				{
					ev.blockList().remove(i--);

					continue;
				}
			}
		}
	}

	@EventHandler
	public void onBlockBreak(BlockBreakEvent ev)
	{
		BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(ev.getBlock().getLocation());

		if (bs == null) { return; }

		if (!ev.getPlayer().hasPermission("magicAspect.crafting.bypassOwnership") && Main.GetInstance().GetConfigManager().isAltarOwnershipChecking() && !ev.getPlayer().getUniqueId().equals(bs.GetOwner()))
		{
			ev.setCancelled(true);

			return;
		}

		RemoveStruct(ev.getPlayer(), bs);
	}

	@EventHandler
	public void onBlockBurn(BlockBurnEvent ev)
	{
		BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(ev.getBlock().getLocation());

		if (bs == null) { return; }

		if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
		{
			RemoveStruct(null, bs);
		}
		else
		{
			ev.setCancelled(true);
		}
	}

	@EventHandler
	public void onBlockFade(BlockFadeEvent ev)
	{
		BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(ev.getBlock().getLocation());

		if (bs == null) { return; }

		if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
		{
			RemoveStruct(null, bs);
		}
		else
		{
			ev.setCancelled(true);
		}
	}

	@EventHandler
	public void onPistonExtend(BlockPistonExtendEvent ev)
	{
		for (Block b : ev.getBlocks())
		{
			BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(b.getLocation());

			if (bs == null)
			{
				continue;
			}

			if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
			{
				RemoveStruct(null, bs);
			}
			else
			{
				ev.setCancelled(true);

				return;
			}
		}
	}

	@EventHandler
	public void onPistonRetract(BlockPistonRetractEvent ev)
	{
		if (!ev.isSticky()) { return; }

		for (Block b : ev.getBlocks())
		{
			BrewingStructure bs = Main.GetInstance().GetBrewingManager().GetStructureBelongsTo(b.getLocation());

			if (bs == null)
			{
				continue;
			}

			if (Main.GetInstance().GetConfigManager().isStructureEnvironmentalDestroy())
			{
				RemoveStruct(null, bs);
			}
			else
			{
				ev.setCancelled(true);

				return;
			}
		}
	}

	private void RemoveStruct(Player p, BrewingStructure bs)
	{
		if (bs != null)
		{
			Main.GetInstance().GetBrewingManager().RemoveStructure(bs);

			if (p != null)
			{
				p.sendMessage(LanguageManager.GetText("cauldron.destroyed"));
			}
		}
	}
}
