package an0nym8us.bukkit.magicCrafting.listener;

import java.util.List;
import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.altar.AltarStructure;
import an0nym8us.bukkit.magicCrafting.altar.IStructure;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.utils.menu.RomanNumeral;

public class AltarSLH implements IStructureListenerHandler
{
	@Override
	public boolean Handle(Player player, Block clickedBlock, boolean isLeftClick)
	{
		if (isLeftClick)
		{
			if(clickedBlock != null)
			{
				if(HandleAltarInteraction(player, clickedBlock, true))
				{
					return true;
				}
			}
			
			return false;
		}
		else
		{
			if (!Main.GetInstance().GetStructureManager().StructureExists(clickedBlock.getLocation()))
			{
				int level = AltarStructure.GetAvailableAltarLevel(clickedBlock.getLocation());

				if (level > 0)
				{
					player.updateInventory();

					if (!player.hasPermission("magicAspect.crafting.create.altar"))
					{
						player.sendMessage(LanguageManager.GetText("altar.create.noPermission"));

						return true;
					}
					else if (!CanCreate(player.getUniqueId()))
					{
						player.sendMessage(LanguageManager.GetText("altar.maxReached"));

						return true;
					}

					int maxLevel = AltarStructure.GetMaxAltarLevel(player.getUniqueId());

					if (level > maxLevel)
					{
						player.sendMessage(LanguageManager.GetFormattedText("altar.tooHighLevel", new RomanNumeral(level).toString(), new RomanNumeral(maxLevel).toString()));
						
						return true;
					}
					
					IStructure struct = AltarStructure.CreateAltarStructure(clickedBlock.getLocation(), player.getUniqueId(), level);
					
					if(struct == null)
					{
						player.sendMessage("An error occurred.");
						
						return true;
					}
					
					Main.GetInstance().GetStructureManager().AddStructure(struct);

					player.sendMessage(LanguageManager.GetText("altar.created"));
					
					return true;
				}
			}
			else
			{
				if (HandleAltarInteraction(player, clickedBlock, false))
				{
					return true;
				}
			}
			
			return false;
		}
	}
	
	private boolean HandleAltarInteraction(Player p, Block b, boolean isLeftClick)
	{
		IStructure struct = Main.GetInstance().GetStructureManager().GetStructure(b.getLocation());
		
		if (struct != null)
		{			
			struct.Click(b.getLocation(), p, isLeftClick);
			
			return true;
		}

		return false;
	}
	
	public boolean CanCreate(UUID player)
	{
		List<IStructure> list = Main.GetInstance().GetStructureManager().GetStructures(player);

		return list.size() < AltarStructure.GetMaxAltarAmount(player);
	}
	
	@SuppressWarnings("unused")
	private boolean remove(Player p, ItemStack is)
	{
		for (int i = 0; i < p.getInventory().getContents().length; i++)
		{
			if (p.getInventory().getContents()[i] != null && p.getInventory().getContents()[i].equals(is))
			{
				ItemStack[] contents = p.getInventory().getContents();
				contents[i] = new ItemStack(Material.AIR);
				p.getInventory().setContents(contents);

				p.updateInventory();

				return true;
			}
		}

		return false;
	}
}
