package an0nym8us.bukkit.magicCrafting.brewing;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;

@SuppressWarnings("deprecation")
public class PotionBrewingRecipe extends BrewingRecipe
{
	boolean canSplash;
	boolean canSecLevel;
	boolean canExtended;

	public PotionBrewingRecipe(ItemStack ingredient0, ItemStack ingredient1, ItemStack result, boolean canSplash, boolean canSecLevel, boolean canExtended)
	{
		super(ingredient0, ingredient1, result);

		this.canSplash = canSplash;
		this.canSecLevel = canSecLevel;
		this.canExtended = canExtended;
	}
	
	@Override
	public ItemStack GetResult(ItemStack ing0, ItemStack ing1)
	{
		if((ing0.isSimilar(this.ingredient0) && ing1.isSimilar(this.ingredient1)) || (ing0.isSimilar(this.ingredient1) && ing1.isSimilar(this.ingredient0)))
		{
			return result;
		}
		
		if (canSplash && (ing0.getType() == Material.SULPHUR || ing1.getType() == Material.SULPHUR))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(p0.getType() == null || p1.getType() == null || !p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.isSplash())
			{
				return null;
			}
			
			p1.setSplash(true);
			
			return p1.toItemStack(1);
		}		
		else if (canSecLevel && (ing0.getType() == Material.GLOWSTONE_DUST || ing1.getType() == Material.GLOWSTONE_DUST))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(p0.getType() == null || p1.getType() == null || !p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.getLevel() > 1 || p1.getType().getMaxLevel() <= p1.getLevel())
			{
				return null;
			}
			
			p1.setLevel(p1.getLevel() + 1);
			
			if(p1.hasExtendedDuration()) { p1.setHasExtendedDuration(false); }
			
			return p1.toItemStack(1);
		}
		else if (canExtended && (ing0.getType() == Material.REDSTONE || ing1.getType() == Material.REDSTONE))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(p0.getType() == null || p1.getType() == null || !p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.hasExtendedDuration() || p1.getType().isInstant())
			{
				return null;
			}
			
			p1.setHasExtendedDuration(true);
			
			if(p1.getLevel() > 1) { p1.setLevel(1); }
			
			return p1.toItemStack(1);
		}
		
		return null;
	}
}
