package an0nym8us.bukkit.magicCrafting.brewing;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;

@SuppressWarnings("deprecation")
public class CrossPotionBrewingRecipe extends PotionBrewingRecipe
{
	public CrossPotionBrewingRecipe(ItemStack ingredient0, ItemStack ingredient1, ItemStack result, boolean canSplash, boolean canSecLevel, boolean canExtended)
	{
		super(ingredient0, ingredient1, result, canSplash, canSecLevel, canExtended);
		
		
	}
	
	@Override
	public ItemStack GetResult(ItemStack ing0, ItemStack ing1)
	{
		ItemStack res = super.GetResult(ing0, ing1);
		
		if(res != null)
		{
			return res;
		}
		
		Potion potion0 = null;
		
		if(ing0.getType() == Material.POTION && (ingredient0.getType() == ing1.getType() || ingredient1.getType() == ing1.getType()))
		{
			potion0 = Potion.fromItemStack(ing0);
		}
		else if(ing1.getType() == Material.POTION && (ingredient0.getType() == ing0.getType() || ingredient1.getType() == ing0.getType()))
		{
			potion0 = Potion.fromItemStack(ing1);
		}
		else
		{
			return null;
		}
		
		Potion potion1 = null;
		
		if(ingredient0.getType() == Material.POTION)
		{
			potion1 = Potion.fromItemStack(ingredient0);
		}
		else if(ingredient1.getType() == Material.POTION)
		{
			potion1 = Potion.fromItemStack(ingredient1);
		}
		else
		{
			return null;
		}
		
		if(!potion0.getType().getEffectType().equals(potion1.getType().getEffectType()))
		{
			return null;
		}
		
		if((!canSplash && potion0.isSplash()) || (!canSecLevel && potion0.getLevel() > 1) || (!canExtended && potion0.hasExtendedDuration()))
		{
			return null;
		}
		
		Potion p0 = Potion.fromItemStack(result);
			
		potion0.setType(p0.getType());
			
		return potion0.toItemStack(1);
	}
}

/*		if((ing0.isSimilar(this.ingredient0) && ing1.isSimilar(this.ingredient1)) || (ing0.isSimilar(this.ingredient1) && ing1.isSimilar(this.ingredient0)))
		{
			return result;
		}
		
		if (canSplash && (ing0.getType() == Material.SULPHUR || ing1.getType() == Material.SULPHUR))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(!p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.isSplash())
			{
				return null;
			}
			
			p1.setSplash(true);
			
			return p1.toItemStack(1);
		}		
		else if (canSecLevel && (ing0.getType() == Material.GLOWSTONE_DUST || ing1.getType() == Material.GLOWSTONE_DUST))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(!p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.getLevel() > 1)
			{
				return null;
			}
			
			p1.setLevel(p1.getLevel() + 1);
			
			if(p1.hasExtendedDuration()) { p1.setHasExtendedDuration(false); }
			
			return p1.toItemStack(1);
		}
		else if (canExtended && (ing0.getType() == Material.REDSTONE || ing1.getType() == Material.REDSTONE))
		{
			ItemStack is = null;
			
			if(ing0.getType() == Material.POTION)
			{
				is = ing0;
			}
			else if(ing1.getType() == Material.POTION)
			{
				is = ing1;
			}
			else
			{
				return null;
			}
			
			Potion p0 = Potion.fromItemStack(result);
			Potion p1 = Potion.fromItemStack(is);
			
			if(!p0.getType().getEffectType().equals(p1.getType().getEffectType()) || p1.hasExtendedDuration())
			{
				return null;
			}
			
			if(p1.getLevel() > 1) { p1.setLevel(1); }
			
			p1.setHasExtendedDuration(true);
			
			return p1.toItemStack(1);
		}*/
