package an0nym8us.bukkit.magicCrafting.brewing;

import java.util.UUID;

import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;

@SuppressWarnings("deprecation")
public class BrewingStructure
{
	LanguageManager languageManager;

	Location loc;
	UUID owner;
	Hologram hologram;

	ItemStack itemIn;

	int ticksRemaining;

	boolean isDisposed = false;

	public BrewingStructure(Location loc, UUID owner)
	{
		this.loc = loc;
		this.owner = owner;

		itemIn = new ItemStack(Material.AIR);

		hologram = HologramsAPI.createHologram(Main.GetInstance(), loc.clone().add(0.5, 2.5, 0.5));

		hologram.appendTextLine(LanguageManager.GetText("cauldron.firstLine"));
		hologram.appendTextLine(LanguageManager.GetText("cauldron.secondLine"));
		hologram.appendTextLine(LanguageManager.GetText("cauldron.thirdLine"));

		languageManager = Main.GetInstance().GetLanguageManager();
	}

	public boolean IsDisposed()
	{
		return isDisposed;
	}

	public UUID GetOwner()
	{
		return owner;
	}

	public boolean CheckCauldronLevel()
	{
		return loc.getBlock().getState().getData().getData() == 3;
	}

	public int GetCauldronLevel()
	{
		return loc.getBlock().getState().getRawData();
	}

	public boolean DecreaseCauldronLevel()
	{
		if (isDisposed || !HandleValidation(loc)) { return false; }
		if (ticksRemaining != 0) { return false; }

		if (loc.getBlock().getState().getRawData() > 0)
		{
			BlockState d = loc.getBlock().getState();
			d.getData().setData((byte) (d.getData().getData() - 1));
			d.update();

			return true;
		}

		return false;
	}

	public void IncreaseCauldronLevel()
	{
		if (isDisposed || !HandleValidation(loc)) { return; }

		if (loc.getBlock().getState().getRawData() < 3)
		{
			BlockState d = loc.getBlock().getState();
			d.getData().setData((byte) (d.getData().getData() + 1));
			d.update();
		}
	}

	public ItemStack GetItemIn()
	{
		return itemIn;
	}

	public Location GetLocation()
	{
		return loc;
	}

	public void Clear()
	{
		if (isDisposed || !HandleValidation(loc)) { return; }

		itemIn = new ItemStack(Material.AIR);
		
		BlockState d = loc.getBlock().getState();
		d.getData().setData((byte) 0);
		d.update();

		hologram.clearLines();
		hologram.appendTextLine(LanguageManager.GetText("cauldron.firstLine"));
		hologram.appendTextLine(LanguageManager.GetText("cauldron.secondLine"));
		hologram.appendTextLine(LanguageManager.GetText("cauldron.thirdLine"));
	}

	public boolean AddItem(ItemStack i)
	{
		if (isDisposed || !HandleValidation(loc) || !this.CheckCauldronLevel()) { return false; }

		BrewingRecipe br = null;

		if (i.getType().equals(Material.POTION)) { return false; }

		try
		{
			if (itemIn.getType() == Material.AIR)
			{
				itemIn = i;

				hologram.clearLines();
				hologram.appendTextLine(LanguageManager.GetText("cauldron.firstLine"));

				hologram.appendTextLine(ChatColor.GOLD + "1. " + languageManager.GetItemName(i));

				br = Main.GetInstance().GetBrewingManager().ContainsRecipe(itemIn, new ItemStack(Material.AIR));

				if (br != null)
				{
					ticksRemaining = Main.GetInstance().GetBrewingManager().GetTime(this.owner);

					hologram.appendTextLine("");
					hologram.appendTextLine(LanguageManager.GetFormattedText("cauldron.producing", languageManager.GetItemName(br.GetResult(itemIn, new ItemStack(Material.AIR)))));
					hologram.appendTextLine(LanguageManager.GetFormattedText("cauldron.in", Integer.toString(ticksRemaining / 20 + 1)));

					itemIn = br.GetResult(itemIn, new ItemStack(Material.AIR));
				}

				return true;
			}
			else
			{
				br = Main.GetInstance().GetBrewingManager().ContainsRecipe(itemIn, i);

				if (br == null) { return false; }

				ticksRemaining = Main.GetInstance().GetBrewingManager().GetTime(this.owner);

				hologram.clearLines();
				hologram.appendTextLine(LanguageManager.GetText("cauldron.firstLine"));

				hologram.appendTextLine(ChatColor.GOLD + "1. " + languageManager.GetItemName(itemIn));
				hologram.appendTextLine(ChatColor.GOLD + "2. " + languageManager.GetItemName(i));

				hologram.appendTextLine(LanguageManager.GetFormattedText("cauldron.producing", languageManager.GetItemName(br.GetResult(itemIn, i))));
				hologram.appendTextLine(LanguageManager.GetFormattedText("cauldron.in", Integer.toString(ticksRemaining / 20 + 1)));

				itemIn = br.GetResult(itemIn, i);

				return true;
			}
		}
		catch (Exception ex)
		{
			this.Dispose();
			
			ex.printStackTrace();
		}

		return false;
	}

	public int GetTicks()
	{
		return ticksRemaining;
	}

	public void Decrease()
	{
		if (isDisposed || !HandleValidation(loc)) { return; }

		ticksRemaining--;
		
		hologram.removeLine(4);
		hologram.appendTextLine(LanguageManager.GetFormattedText("cauldron.in", Integer.toString(ticksRemaining / 20 + 1)));

		if (ticksRemaining == 0)
		{
			hologram.clearLines();
			hologram.appendTextLine(LanguageManager.GetText("cauldron.firstLine"));
			hologram.appendTextLine(ChatColor.GOLD + "1. " + languageManager.GetItemName(itemIn));
		}
	}

	private boolean HandleValidation(Location loc)
	{
		if (loc.getBlock().getType().equals(Material.CAULDRON)) { return true; }

		this.Dispose();

		return false;
	}

	public boolean DoesBelong(Location loc)
	{
		return this.loc.getBlockY() == loc.getBlockY() && this.loc.getBlockX() == loc.getBlockX() && this.loc.getBlockZ() == loc.getBlockZ() && this.loc.getWorld().equals(loc.getWorld());
	}

	public void Dispose()
	{
		hologram.delete();

		if (itemIn != null && !itemIn.getType().equals(Material.AIR) && !itemIn.getType().equals(Material.POTION))
		{
			loc.getWorld().dropItem(loc.clone().add(0.5, 0.75, 0.5), itemIn);
		}

		isDisposed = true;
	}
}
