package an0nym8us.bukkit.magicCrafting.brewing;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class BrewingRecipe
{
	protected ItemStack ingredient0, ingredient1;
	protected ItemStack result;

	public BrewingRecipe(ItemStack ingredient0, ItemStack ingredient1, ItemStack result)
	{
		this.ingredient0 = ingredient0 == null ? new ItemStack(Material.AIR) : ingredient0;
		this.ingredient1 = ingredient1 == null ? new ItemStack(Material.AIR) : ingredient1;
		this.result = result == null ? new ItemStack(Material.AIR) : result;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj instanceof BrewingRecipe)
		{
			BrewingRecipe br = (BrewingRecipe) obj;

			return br.ingredient0.isSimilar(ingredient0) && br.ingredient1.isSimilar(ingredient1) && br.result.isSimilar(result);
		}

		return false;
	}

	public boolean DoesMatch(ItemStack ing0, ItemStack ing1)
	{
		return GetResult(ing0, ing1) != null;
	}

	public ItemStack GetResult(ItemStack ing0, ItemStack ing1)
	{
		return (ingredient0.isSimilar(ing0) && ingredient1.isSimilar(ing1)) || (ingredient0.isSimilar(ing1) && ingredient1.isSimilar(ing0)) ? result
																																																																																		: null;
	}

	public int GetTicks()
	{
		return 160;
	}
}
