package an0nym8us.bukkit.magicCrafting.brewing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

import an0nym8us.bukkit.magicCrafting.Main;

@SuppressWarnings("deprecation")
public class BrewingManager
{
	private static final ItemStack POTION = new ItemStack(Material.POTION, 1, (short) 16);
	List<BrewingStructure> structures;
	List<BrewingRecipe> recipes;

	Runnable task;
	int taskID;
	
	public BrewingManager(boolean enableTask)
	{
		structures = new ArrayList<BrewingStructure>();
		recipes = new ArrayList<BrewingRecipe>();

		recipes.add(new BrewingRecipe(null, new ItemStack(Material.NETHER_STALK),
				new ItemStack(Material.POTION, 1, (short) 16)));
		AddPotion(new ItemStack(Material.BLAZE_POWDER), new Potion(PotionType.STRENGTH));
		AddPotion(new ItemStack(Material.GOLDEN_CARROT), new Potion(PotionType.NIGHT_VISION));
		AddPotion(new ItemStack(Material.MAGMA_CREAM), new Potion(PotionType.FIRE_RESISTANCE));
		AddPotion(new ItemStack(Material.SUGAR), new Potion(PotionType.SPEED));
		AddPotion(new ItemStack(Material.RAW_FISH, 1, (byte) 3), new Potion(PotionType.WATER_BREATHING));
		AddPotion(new ItemStack(Material.SPECKLED_MELON), new Potion(PotionType.INSTANT_HEAL));
		AddPotion(new ItemStack(Material.SPIDER_EYE), new Potion(PotionType.POISON));
		AddPotion(new ItemStack(Material.GHAST_TEAR), new Potion(PotionType.REGEN));
		AddPotion(new Potion(PotionType.NIGHT_VISION), new ItemStack(Material.FERMENTED_SPIDER_EYE),
				new Potion(PotionType.INVISIBILITY));
		AddPotion(new Potion(PotionType.INSTANT_HEAL), new ItemStack(Material.FERMENTED_SPIDER_EYE),
				new Potion(PotionType.INSTANT_DAMAGE));
		AddPotion(new Potion(PotionType.POISON), new ItemStack(Material.FERMENTED_SPIDER_EYE),
				new Potion(PotionType.INSTANT_DAMAGE));
		AddPotion(new Potion(PotionType.SPEED), new ItemStack(Material.FERMENTED_SPIDER_EYE),
				new Potion(PotionType.SLOWNESS));
		AddPotion(new Potion(PotionType.FIRE_RESISTANCE), new ItemStack(Material.FERMENTED_SPIDER_EYE),
				new Potion(PotionType.SLOWNESS));

		if (!enableTask) { return; }

		task = new Runnable()
		{
			@Override
			public void run()
			{
				synchronized (structures)
				{
					for (BrewingStructure bs : structures)
					{
						if (bs.IsDisposed())
						{
							continue;
						}

						if (bs.ticksRemaining > 0)
						{
							try
							{
								bs.Decrease();
							}
							catch (Exception ex)
							{
								ex.printStackTrace();

								bs.Dispose();

								continue;
							}
						}
						else
						{
							for (Item i : bs.loc.getWorld().getEntitiesByClass(Item.class))
							{
								try
								{
									if (bs.loc.getBlock().getLocation()
											.distance(i.getLocation().getBlock().getLocation()) == 0)
									{
										if (bs.AddItem(i.getItemStack()))
										{
											i.remove();
										}
									}
								}
								catch (IllegalArgumentException ex)
								{}
							}
						}
					}
				}
			}
		};

		taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask(Main.GetInstance(), task, 1, 1);
	}

	private void AddPotion(ItemStack neededItem0, Potion pot)
	{
		recipes.add(new PotionBrewingRecipe(POTION, neededItem0, pot.toItemStack(1), true, true, true));
	}

	private void AddPotion(Potion pot0, ItemStack neededItem, Potion pot1)
	{
		recipes.add(
				new CrossPotionBrewingRecipe(pot0.toItemStack(1), neededItem, pot1.toItemStack(1), true, true, true));
	}

	public void AddBrewingStructure(Location loc, UUID owner)
	{
		structures.add(new BrewingStructure(loc, owner));
	}

	public int GetStructureAmount(UUID uuid)
	{
		int res = 0;

		for (BrewingStructure bs : structures)
		{
			if (bs.GetOwner().equals(uuid))
			{
				res++;
			}
		}

		return res;
	}

	public int GetMaxStructureAmount(UUID uuid)
	{
		if (Bukkit.getPlayer(uuid) == null) { return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer(); }

		String val = Main.GetPermissionParameter(uuid, "magicAspect.crafting.create.cauldron");

		if (val == null
				|| val.equals("default")) { return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer(); }

		try
		{
			int res = Integer.parseInt(val);

			return res > 0 ? res : Integer.MAX_VALUE;
		}
		catch (NumberFormatException ex)
		{
			Bukkit.getLogger()
					.warning(ChatColor.YELLOW
							+ "Corrupted max altar amount in permissions; permission: \"magicAspect.crafting.create.cauldron."
							+ val + "\"");
		}

		return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer();
	}

	public void AddRecipe(BrewingRecipe recipe)
	{
		if (recipe == null) { return; }

		recipes.add(recipe);
	}

	public List<BrewingStructure> GetStructures(UUID owner)
	{
		List<BrewingStructure> res = new ArrayList<BrewingStructure>();

		synchronized (structures)
		{
			for (BrewingStructure struct : structures)
			{
				if (struct.GetOwner().equals(owner))
				{
					res.add(struct);
				}
			}
		}

		return res;
	}

	public boolean StructureExist(Location loc)
	{
		for (BrewingStructure struct : structures)
		{
			try
			{
				if (struct.loc.getBlock().getLocation().distance(loc.getBlock().getLocation()) == 0) { return true; }
			}
			catch (IllegalArgumentException ex)
			{}
		}

		return false;
	}

	public BrewingStructure GetStructure(Location loc)
	{
		for (BrewingStructure struct : structures)
		{
			try
			{
				if (struct.loc.getBlock().getLocation().distance(loc.getBlock().getLocation()) == 0) { return struct; }
			}
			catch (IllegalArgumentException ex)
			{}
		}

		return null;
	}

	public int GetTime(UUID uuid)
	{
		if (uuid == null
				|| Bukkit.getPlayer(uuid) == null) { return Main.GetInstance().GetConfigManager().getBrewingTime(); }

		String val = Main.GetPermissionParameter(uuid, "magicAspect.crafting.brewingTime");

		if (val == null || val.equals("default")) { return Main.GetInstance().GetConfigManager().getBrewingTime(); }

		try
		{
			return Integer.parseInt(val);
		}
		catch (NumberFormatException ex)
		{
			Bukkit.getLogger()
					.warning(ChatColor.YELLOW
							+ "Corrupted brewing time in permissions; permission: \"magicAspect.crafting.brewingTime."
							+ val + "\"");
		}

		return Main.GetInstance().GetConfigManager().getBrewingTime();
	}

	public BrewingStructure GetStructureBelongsTo(Location loc)
	{
		for (BrewingStructure struct : structures)
		{
			if (struct.DoesBelong(loc)) { return struct; }
		}

		return null;
	}

	public void RemoveStructure(BrewingStructure struct)
	{
		struct.Dispose();

		structures.remove(struct);
	}

	public BrewingRecipe ContainsRecipe(ItemStack ingredient0, ItemStack ingredient1)
	{
		for (BrewingRecipe br : recipes)
		{
			if (br.GetResult(ingredient0, ingredient1) != null) { return br; }
		}

		return null;
	}

	public List<BrewingRecipe> GetRecipes()
	{
		return recipes;
	}

	public void DisposeStructures()
	{
		while (structures.size() != 0)
		{
			RemoveStructure(structures.get(0));
		}
	}

	public void Dispose()
	{
		DisposeStructures();

		Bukkit.getScheduler().cancelTask(taskID);
	}
}
