package an0nym8us.bukkit.magicCrafting.altar.recipeCreation;

import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.altar.AltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.IAltarStructure;
import an0nym8us.bukkit.magicCrafting.altar.ShapedAltarRecipe;
import an0nym8us.bukkit.magicCrafting.altar.ShapelessAltarRecipe;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.cyanide.ICreationHandler;
import an0nym8us.cyanide.ICreationInterface;
import an0nym8us.utils.menu.SiteMenuInventorySession;
import net.md_5.bungee.api.ChatColor;

public class DeprecatedRecipeCreationMenuSession extends SiteMenuInventorySession<DeprecatedRecipeCreationMenu> implements ICreationInterface<AltarRecipe>
{
	boolean isShaped = false;
	boolean checkOnlyType = true;
	boolean ignoreDurability = false;
	String name = null;
	double price = -1.d;

	IAltarStructure ingredientsStruct;
	IAltarStructure resultsStruct;

	ICreationHandler<AltarRecipe> creationHandler;
	
	public DeprecatedRecipeCreationMenuSession(UUID owner, DeprecatedRecipeCreationMenu menu)
	{
		this(menu.CreateSession(), owner, menu);
	}
	
	public DeprecatedRecipeCreationMenuSession(Inventory inv, UUID owner, DeprecatedRecipeCreationMenu menu)
	{
		this(inv, owner,menu, null, null, null);
	}
			
			
	public DeprecatedRecipeCreationMenuSession(Inventory inv, UUID owner, DeprecatedRecipeCreationMenu menu,
			IAltarStructure ingredientsStruct, IAltarStructure resultsStruct,
			ICreationHandler<AltarRecipe> creationHandler)
	{
		super(inv, owner, menu);

		this.ingredientsStruct = ingredientsStruct;
		this.resultsStruct = resultsStruct;

		this.creationHandler = creationHandler;
	}

	public AltarRecipe PrepareRecipe()
	{
		AltarRecipe ar;

		ItemStack[] ingredients = ingredientsStruct.GetItemArray();

		if (isShaped)
		{
			ar = new ShapedAltarRecipe(GetResultItem(), checkOnlyType, ignoreDurability,
					ShapedAltarRecipe.getRecipe(ingredients, checkOnlyType, ignoreDurability),
					ShapedAltarRecipe.getMap(ingredients, checkOnlyType, ignoreDurability));
		}
		else
		{
			ar = new ShapelessAltarRecipe(GetResultItem(), checkOnlyType, ignoreDurability, ingredients);
		}

		ar.SetName(name);
		ar.SetPrice(price);

		return ar;
	}

	public ICreationHandler<String> GetNameHandler()
	{
		return new ICreationHandler<String>()
		{
			@Override
			public void onCreationHandle(ICreationInterface<String> creationInterface)
			{
				String name = creationInterface.Return();
				
				if (name.equals("~"))
				{
					DeprecatedRecipeCreationMenuSession.this.name = null;
					
					GetPlayerOwner().sendMessage(LanguageManager.GetText("nameRemoved"));
				}
				else
				{
					DeprecatedRecipeCreationMenuSession.this.name = creationInterface.Return();
					
					GetPlayerOwner().sendMessage(LanguageManager.GetText("nameSet"));
				}

				DeprecatedRecipeCreationMenuSession.this.Open(GetPlayerOwner());
			}
		};
	}

	public ICreationHandler<String> GetPriceHandler()
	{
		return new ICreationHandler<String>()
		{

			@Override
			public void onCreationHandle(ICreationInterface<String> creationInterface)
			{
				Double price;
				
				try
				{
					price = Double.parseDouble(creationInterface.Return());
				}
				catch (NumberFormatException ex)
				{
					GetPlayerOwner().sendMessage(ChatColor.RED + "Wrong input! Operation aborted!");

					return;
				}
				
				if (price <= 0)
				{
					DeprecatedRecipeCreationMenuSession.this.price = -1.d;

					GetPlayerOwner().sendMessage(LanguageManager.GetText("priceRemoved"));

					return;
				}

				DeprecatedRecipeCreationMenuSession.this.price = price;
				
				GetPlayerOwner().sendMessage(LanguageManager.GetText("priceSet"));

				DeprecatedRecipeCreationMenuSession.this.Open(GetPlayerOwner());
			}
		};
	}

	public ICreationHandler<IAltarStructure> GetIngredientsHandler()
	{
		return new ICreationHandler<IAltarStructure>()
		{

			@Override
			public void onCreationHandle(ICreationInterface<IAltarStructure> creationInterface)
			{
				DeprecatedRecipeCreationMenuSession.this.ingredientsStruct = creationInterface.Return();

				DeprecatedRecipeCreationMenuSession.this.Open(GetPlayerOwner());
			}
		};
	}

	public ICreationHandler<IAltarStructure> GetResultsHandler()
	{
		return new ICreationHandler<IAltarStructure>()
		{
			@Override
			public void onCreationHandle(ICreationInterface<IAltarStructure> creationInterface)
			{
				DeprecatedRecipeCreationMenuSession.this.resultsStruct = creationInterface.Return();

				DeprecatedRecipeCreationMenuSession.this.Open(GetPlayerOwner());
			}
		};
	}

	public boolean HasIngredientItems()
	{
		ItemStack[] ar = ingredientsStruct.GetItemArray();

		for (ItemStack is : ar)
		{
			if (is != null && is.getType().equals(Material.AIR) && is.getAmount() < 1) { return true; }
		}

		return false;
	}

	public boolean HasResultItems()
	{
		ItemStack[] ar = resultsStruct.GetItemArray();

		for (ItemStack is : ar)
		{
			if (is != null && is.getType().equals(Material.AIR) && is.getAmount() < 1) { return true; }
		}

		return false;
	}

	public ItemStack GetResultItem()
	{
		ItemStack[] ar = resultsStruct.GetItemArray();

		for (ItemStack is : ar)
		{
			if (is != null && is.getType().equals(Material.AIR) && is.getAmount() < 1) { return is; }
		}

		return null;
	}

	public void CallEnd()
	{
		creationHandler.onCreationHandle(this);
	}

	/*
	 * @Override public void onCreationHandle(CreationInterface<Object>
	 * creationInterface) { Object obj = creationInterface.Return();
	 * 
	 * if (obj instanceof String) { String output = (String) obj;
	 * 
	 * if (inputState) { try { price = Double.parseDouble(output); } catch
	 * (NumberFormatException ex) { GetPlayerOwner().sendMessage(ChatColor.RED +
	 * "Wrong input! Operation aborted!");
	 * 
	 * return; } } else { name = output; } } else if (obj instanceof
	 * IAltarStructure) { if (inputState) { resultsStruct = (IAltarStructure)
	 * obj; } else { ingredientsStruct = (IAltarStructure) obj; } } else { throw
	 * new IllegalArgumentException("Wrong return type!"); }
	 * 
	 * this.Open(GetPlayerOwner()); }
	 */

	@Override
	public boolean BeginCreation()
	{
		this.Open(this.GetPlayerOwner());

		return true;
	}

	@Override
	public AltarRecipe Return()
	{
		return PrepareRecipe();
	}
}
