package an0nym8us.bukkit.magicCrafting.altar.recipeCreation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.UUID;

import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ConstantTranslation;
import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.cyanide.StringTextCreationInterface;
import an0nym8us.utils.menu.SiteMenu;

// Creation of ShapelessAltarRecipe and ShapedAltarRecipe
public class DeprecatedRecipeCreationMenu extends SiteMenu
{
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.recipeList", defaultName = "bRecipe List")
	private static ItemStack RECIPE_LIST = ISBuilder.CreateIS(Material.COMPASS).SetName(ChatColor.AQUA + "Recipe List")
			.GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.createRecipe", defaultName = "aCreate Recipe")
	private static ItemStack MODIFY_RECIPE = ISBuilder.CreateIS(Material.NETHER_STAR)
			.SetName(ChatColor.GREEN + "Create Recipe").GetResult();

	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.list.modify", defaultName = "6Modify Recipe",
			desc = { "eTo modify recipe you need to create Recipe Creator Structure first." })
	private static ItemStack MODIFY = ISBuilder.CreateIS(Material.TRIPWIRE_HOOK)
			.SetName(ChatColor.GOLD + "Modify Recipe").GetResult();
	@ConstantTranslation(nameCode = "DeprecatedRecipeCreationMenu.impresentable",
			defaultName = "bImpresentable Recipe")
	private static ItemStack IMPRESENTABLE_RECIPE = ISBuilder.CreateIS(Material.BARRIER)
			.SetName(ChatColor.DARK_RED + "Impresentable Recipe").GetResult();

	// private static ItemStack RECIPE_FRAME =
	// ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 9).GetResult();
	// private static ItemStack RESULT_FRAME =
	// ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte) 4).GetResult();
	// private static ItemStack BOOLEAN_FRAME =
	// ISBuilder.CreateIS(Material.STAINED_GLASS_PANE, 1, (byte)
	// 14).GetResult();

	private static final int _1_MODIFY_INDEX = 7;
	private static final int _1_REMOVE_INDEX = 3;
	private static final int _1_PREVIOUS_INDEX = 9;
	private static final int _1_NEXT_INDEX = 1;
	private static final int _1_BACK_INDEX = 5;

	@ConstantTranslation(nameCode = "adminMenu.modifier.shapelessButton", defaultName = "bShaped",
			desc = "aSet recipe as shaped")
	private static ItemStack SHAPED = ISBuilder.CreateDyeItemStack(DyeColor.GREEN)
			.SetName(ChatColor.DARK_GREEN + "Shaped").AddLoreLine(ChatColor.GREEN + "Set recipe as shaped").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.shapedButton", defaultName = "bShapeless",
			desc = "cSet recipe as shapeless")
	private static ItemStack SHAPELESS = ISBuilder.CreateDyeItemStack(DyeColor.RED)
			.SetName(ChatColor.DARK_RED + "Shapeless").AddLoreLine(ChatColor.RED + "Set recipe as shapeless")
			.GetResult();

	@ConstantTranslation(nameCode = "adminMenu.modifier.enableButton", defaultName = "bEnable",
			desc = "aEnable this feature")
	private static ItemStack ENABLE = ISBuilder.CreateDyeItemStack(DyeColor.GREEN)
			.SetName(ChatColor.DARK_GREEN + "Enable").AddLoreLine(ChatColor.GREEN + "Enable this feature").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.disableButton", defaultName = "bDisable",
			desc = "cDisable this feature")
	private static ItemStack DISABLE = ISBuilder.CreateDyeItemStack(DyeColor.RED)
			.SetName(ChatColor.DARK_RED + "Disable").AddLoreLine(ChatColor.RED + "Disable this feature").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.shapingDescButton",
			defaultName = "bShaping", desc = "cLeft button accords to Shapeless recipe, right button to Shaped")
	private static ItemStack SHAPING_VALUE = ISBuilder.CreateIS(Material.NETHER_STAR)
			.SetName(ChatColor.DARK_RED + "Shaping")
			.AddLoreLine(ChatColor.RED + "Left button accords to Shapeless recipe, right button to Shaped").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.doesCheckTypeDescButton",
			defaultName = "bCheck Only Type", desc = "cSet this option using left or right button")
	private static ItemStack CHECK_TYPE_VALUE = ISBuilder.CreateIS(Material.BEACON)
			.SetName(ChatColor.DARK_RED + "Check Only Type")
			.AddLoreLine(ChatColor.RED + "Set this option using left or right button").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.ignoreDurabilityDescButton",
			defaultName = "bIgnore Durability", desc = "cSet this option using left or right button")
	private static ItemStack IGNORE_DUR_VALUE = ISBuilder.CreateIS(Material.ANVIL)
			.SetName(ChatColor.DARK_RED + "Ignore Durability")
			.AddLoreLine(ChatColor.RED + "Set this option using left or right button").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.setNameButton", defaultName = "bSet Name",
			desc = "cSet this option using left or right button")
	private static ItemStack SET_NAME = ISBuilder.CreateIS(Material.NAME_TAG).SetName(ChatColor.DARK_RED + "Set Name")
			.AddLoreLine(ChatColor.RED + "Set this option using left or right button").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.setPriceButton", defaultName = "bSet Price",
			desc = "cSet this option using left or right button")
	private static ItemStack SET_PRICE = ISBuilder.CreateIS(Material.GOLD_INGOT)
			.SetName(ChatColor.DARK_RED + "Set Price")
			.AddLoreLine(ChatColor.RED + "Set this option using left or right button").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.createRecipeButton",
			defaultName = "6Create Recipe")
	private static ItemStack CREATE_RECIPE_BUTTON = ISBuilder.CreateIS(Material.GOLD_PICKAXE)
			.SetName(ChatColor.GOLD + "Create Recipe").GetResult();
	@ConstantTranslation(nameCode = "adminMenu.modifier.modifyRecipeButton",
			defaultName = "6Confirm Modified Recipe")
	private static ItemStack MODIFY_RECIPE_BUTTON = ISBuilder.CreateIS(Material.GOLD_PICKAXE)
			.SetName(ChatColor.GOLD + "Confirm Modified Recipe").GetResult();
	
	@ConstantTranslation(nameCode = "adminMenu.modifier.setIngredientsStruct",
			defaultName = "6Set Ingredients Structure")
	private static ItemStack SET_INGR_BUTTON = ISBuilder.CreateIS(Material.GOLD_PICKAXE)
			.SetName(ChatColor.GOLD + "6Set Ingredients Structure").GetResult();
	
	@ConstantTranslation(nameCode = "adminMenu.modifier.setResultsStructure",
			defaultName = "6Set Results Structure")
	private static ItemStack SET_RESULT_BUTTON = ISBuilder.CreateIS(Material.GOLD_PICKAXE)
			.SetName(ChatColor.GOLD + "6Set Results Structure").GetResult();

	private static final int _2_BACK_INDEX = 44;

	private static final int ITEMS_PER_SITE = 9 * 4;

	private static final int size = 54;

	
	public DeprecatedRecipeCreationMenu()
	{
		super();
		
		sites.add(Init0xSite());
	}
	
	private MobilSite Init0xSite()
	{
		ItemStack[] content = new ItemStack[size];
		HashMap<Integer, Method> actions = new HashMap<Integer, Method>();

		try
		{
			for (int i = 0; i < size; i++)
			{
				content[i] = i < ITEMS_PER_SITE ? DARK_EMPTY_SLOT.clone() : LIGHT_EMPTY_SLOT.clone();
			}

			content[1] = SHAPELESS.clone();
			content[10] = DISABLE.clone();
			content[19] = DISABLE.clone();
			content[2] = SHAPING_VALUE.clone();
			content[11] = CHECK_TYPE_VALUE.clone();
			content[20] = IGNORE_DUR_VALUE.clone();
			content[3] = SHAPED.clone();
			content[12] = ENABLE.clone();
			content[21] = ENABLE.clone();

			content[40] = CREATE_RECIPE_BUTTON.clone();
			content[_2_BACK_INDEX] = BACK.clone();

			actions.put(1, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(10, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(19, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(2, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(11, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(20, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(3, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(12, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(21, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(16, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(25, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(26, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(27, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(40, this.getClass().getDeclaredMethod("Site0xAction", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
			actions.put(44, this.getClass().getDeclaredMethod("SiteXxBack", DeprecatedRecipeCreationMenu.class,
					DeprecatedRecipeCreationMenuSession.class, InventoryClickEvent.class));
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		try
		{
			return new MobilSite(LanguageManager.GetText("DeprecatedRecipeCreationMenu.recipeModifier.title"), actions,
					content, new boolean[size],
					this.getClass().getDeclaredMethod("Site0x_prepare", int.class, UUID.class, DeprecatedRecipeCreationMenuSession.class, ItemStack[].class));
		}
		catch (NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
			
			return null;
		}
	}
	
	/*@Override
	public DeprecatedRecipeCreationMenuSession CreateSession(UUID uuid, int siteID)
	{
		Site site =  sites.get(siteID);		
		Inventory inv = Bukkit.createInventory(null, site.GetLength(), site.title);
		//DeprecatedRecipeCreationMenuSession session = new DeprecatedRecipeCreationMenuSession(inv, uuid, this, siteID);		
		ItemStack[] content = sites.get(siteID).GetItemStacks(siteID, uuid, session, this);

		if (content == null) { return null; }

		for (int i = 0; i < content.length; i++)
		{
			inv.setItem(i, content[i]);
		}

		return session;
	}*/
	
	public void Site0xAction(DeprecatedRecipeCreationMenu menu, DeprecatedRecipeCreationMenuSession session,
			InventoryClickEvent ev)
	{
		if (!Main.GetInstance().GetAltarManager().HasModifierStruct(ev.getWhoClicked().getUniqueId())) { return; }

		switch (ev.getSlot())
		{
			case 1:
				session.isShaped = false;
				break;
			case 10:
				session.checkOnlyType = false;
				break;
			case 19:
				session.ignoreDurability = false;
				break;
			case 3:
				session.isShaped = true;
				break;
			case 12:
				session.checkOnlyType = true;
				break;
			case 21:
				session.ignoreDurability = true;
				break;
			case 16:
				StringTextCreationInterface stci = new StringTextCreationInterface(ev.getWhoClicked().getUniqueId(), session.GetNameHandler());

				if (stci.BeginCreation())
				{
					ev.getWhoClicked().closeInventory();
				}

				break;
			case 25:
				stci = new StringTextCreationInterface(ev.getWhoClicked().getUniqueId(), session.GetPriceHandler());

				if (stci.BeginCreation())
				{
					ev.getWhoClicked().closeInventory();
				}

				break;
			case 40:
				if (!session.HasResultItems())
				{
					LanguageManager.SendMessage(ev.getWhoClicked().getUniqueId(),
							LanguageManager.GetText("recipeCreatorStructure.noResultItem"));

					return;
				}

				if (!session.HasIngredientItems())
				{
					LanguageManager.SendMessage(ev.getWhoClicked().getUniqueId(),
							LanguageManager.GetText("recipeCreatorStructure.noIngredients"));

					return;
				}
				
				session.CallEnd();
				
				MenuManager.GetInstance().RemoveSession(session);

				break;
			default:
				return;
		}

		ev.getInventory()
				.setContents(Site0x_prepare(2, ev.getWhoClicked().getUniqueId(), session, ev.getInventory().getContents()));
	}

	public void SiteXxBack(DeprecatedRecipeCreationMenu menu, DeprecatedRecipeCreationMenuSession session,
			InventoryClickEvent ev)
	{
		SwitchSite(session, 0);
	}
	
	public ItemStack[] Site0x_prepare(int siteID, UUID uuid, DeprecatedRecipeCreationMenuSession session, ItemStack[] is)
	{
		if (session.ingredientsStruct == null || session.resultsStruct == null)
		{
			LanguageManager.SendMessage(uuid, LanguageManager.GetText("recipeCreatorStructure.notExists"));

			return null;
		}

		is[2] = new ISBuilder(SHAPING_VALUE.clone()).AddLoreLine(LanguageManager.GetFormattedText("adminMenu.list.modifier.valueDesc", LanguageManager.GetText(session.isShaped ? "shaped"
																																																																																		: "shapeless")))
																																																																																		.GetResult();

		is[11] = new ISBuilder(CHECK_TYPE_VALUE.clone()).AddLoreLine(LanguageManager.GetFormattedText("adminMenu.list.modifier.valueDesc", LanguageManager.GetText(session.checkOnlyType ? "yes"
																																																																																		: "no")))
																																																																																		.GetResult();
		is[20] = new ISBuilder(IGNORE_DUR_VALUE.clone()).AddLoreLine(LanguageManager.GetFormattedText("adminMenu.list.modifier.valueDesc", LanguageManager.GetText(session.ignoreDurability ? "yes"
																																																																																		: "no")))
																																																																																		.GetResult();

		is[16] = new ISBuilder(SET_NAME.clone()).AddLoreLine(session.name != null ? LanguageManager.GetFormattedText("adminMenu.list.modifier.valueDesc", session.name)
																																																																																		: LanguageManager.GetFormattedText("adminMenu.list.modifier.nullValueDesc"))
																																																																																		.GetResult();
		is[25] = new ISBuilder(SET_PRICE.clone()).AddLoreLine(session.price >= 0.d ? LanguageManager.GetFormattedText("adminMenu.list.modifier.valueDesc", Double.toString(session.price))
																																																																																		: LanguageManager.GetFormattedText("adminMenu.list.modifier.nullValueDesc"))
																																																																																		.GetResult();

		/*if (rcs.GetCurrentRecipe() != null)
		{
			is[40] = MODIFY_RECIPE_BUTTON.clone();

			InventoryTitleHelper.sendInventoryTitle(Bukkit.getPlayer(uuid), LanguageManager.GetText("adminMenu.recipeModifier.modifyingTitle"));
		}*/

		return is;
	}
}
