package an0nym8us.bukkit.magicCrafting.altar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;

public class ShapelessAltarRecipe extends AltarRecipe implements IPresentable
{
	private static final long serialVersionUID = 7654293539638947476L;
	
	private static final int MAX_INGREDIENTS_PRESENT = 12;
	
	boolean checkOnlyType;
	boolean ignoreDurability;
	
	transient ItemStack result;
	transient ItemStack[] pattern;
	
	private transient ItemStack presentationIS;
	
	public ShapelessAltarRecipe(ItemStack result, ItemStack[] pattern,  boolean checkOnlyType, boolean ignoreDurability)
	{
		this(null, 0, result, pattern, checkOnlyType, ignoreDurability);
	}
	
	public ShapelessAltarRecipe(String recipeName, double recipePrice, ItemStack result, ItemStack[] pattern, boolean checkOnlyType, boolean ignoreDurability)
	{
		super(recipeName, recipePrice);
		
		this.result = result;
		this.pattern = pattern;
		
		this.checkOnlyType = checkOnlyType;
		this.ignoreDurability = ignoreDurability;
		
		UpdatePresentationIS();
	}
	
	@SuppressWarnings("unchecked")
	private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
	{
		ois.defaultReadObject();

		pattern = _DeserializeISArray((Map<String, Object>[]) ois.readObject());
		result = _DeserializeIS((Map<String, Object>) ois.readObject());

		UpdatePresentationIS();
	}
	
	private void writeObject(ObjectOutputStream oos) throws IOException
	{
		oos.defaultWriteObject();

		oos.writeObject(_SerializeISArray(pattern));
		oos.writeObject(_SerializeIS(result));
	}
	
	public void UpdatePresentationIS()
	{
		ISBuilder res = new ISBuilder(result.clone());
		res.SetName(LanguageManager.GetFormattedText("recipeTemplate.title",
				Main.GetInstance().GetLanguageManager().GetItemName(result), Integer.toString(result.getAmount())));

		List<String> lore = new ArrayList<String>();

		if (HasName())
		{
			lore.add(LanguageManager.GetFormattedText("recipeTemplate.name", GetName()));
		}
		if (HasPrice())
		{
			lore.add(LanguageManager.GetFormattedText("recipeTemplate.price", Double.toString(GetPrice())));
		}

		if (lore.size() != 0)
		{
			lore.add("");
		}

		lore.add(LanguageManager.GetFormattedText("recipeTemplate.type",
				this instanceof ShapedAltarRecipe ? "Shaped" : "Shapeless"));
		lore.add(LanguageManager.GetFormattedText("recipeTemplate.checkOnlyType",
				LanguageManager.GetText(checkOnlyType ? "yes" : "no")));
		lore.add(LanguageManager.GetFormattedText("recipeTemplate.ignoreDurability",
				LanguageManager.GetText(ignoreDurability ? "yes" : "no")));

		lore.add("");

		lore.add(LanguageManager.GetText("recipeTemplate.ingredients"));

		int counter = 0;

		for (ItemStack is : pattern)
		{
			if (!IsNull(is))
			{
				counter++;
			}
		}

		if (counter <= MAX_INGREDIENTS_PRESENT)
		{
			for (ItemStack is : pattern)
			{
				if (IsNull(is))
				{
					continue;
				}

				lore.add(LanguageManager.GetFormattedText("recipeTemplate.ingredientData",
						Main.GetInstance().GetLanguageManager().GetItemName(is), Integer.toString(is.getAmount())));
			}
		}
		else
		{
			lore.add(LanguageManager.GetText("recipeTemplate.tooManyIngredients"));
			lore.add("");
		}

		res.SetLore(lore);

		presentationIS = res.GetResult();
	}
	
	@Override
	public ItemStack GetPresentationIS()
	{
		return presentationIS;
	}
	
	@Override
	public ItemStack[] GetIngredients()
	{
		return pattern;
	}
	
	public final int MatchIS(ItemStack pattern, ItemStack ingredient)
	{
		return MatchIS(pattern, ingredient, checkOnlyType, ignoreDurability);
	}

	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		return Round(input.GetIngredients());
		/*ItemStack[] ingredients = MergeIngredients(input.GetIngredients());
		
		outloop: for(int i = 0; i < pattern.length; i++)
		{
			for(int j = 0; j < ingredients.length; j++)
			{
				if(MatchIS(pattern[i], ingredients[j]) > 0)
				{
					ingredients[j].setAmount(ingredients[j].getAmount() - pattern[i].getAmount());
					
					continue outloop;
				}
			}
			
			return false;
		}
		
		return true;*/
	}

	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		ItemStack[][] ingredients = input.GetIngredients();		
		int steps = Process(ingredients);
		
		ItemStack res = result.clone();
		res.setAmount(res.getAmount() * steps);
		
		return new ItemAltarRecipeOutput(ingredients, res);
	}
	
	public int Process(ItemStack[][] ingredients)
	{		
		int i = 0;
		
		while(Round(ingredients))
		{
			i++;
		}
		
		return i;
	}
	
	protected boolean Round(ItemStack[][] externalIngredients)
	{
		ItemStack[][] ingredients = new ItemStack[externalIngredients.length][];
		
		for(int i = 0; i < externalIngredients.length; i++)
		{
			ingredients[i] = new ItemStack[externalIngredients[i].length];
			
			for(int j = 0; j < externalIngredients[i].length; j++)
			{
				ingredients[i][j] = externalIngredients[i][j] == null ? null : externalIngredients[i][j].clone();
			}
		}
		
		outloop: for(int i = 0; i < pattern.length; i++)
		{
			for(int j = 0; j < ingredients.length; j++)
			{
				for(int k = 0; k < ingredients[j].length; k++)
				{
					if(MatchIS(pattern[i], ingredients[j][k]) > 0)
					{
						if(ingredients[j][k].getAmount() - pattern[i].getAmount() <= 0)
						{
							ingredients[j][k] = null;
						}
						else
						{
							ingredients[j][k].setAmount(ingredients[j][k].getAmount() - pattern[i].getAmount());
						}
						
						continue outloop;
					}
				}
			}
			
			return false;
		}
		
		return true;
	}

	@Override
	public MultiplyingMode GetMultiplyingMode()
	{
		return MultiplyingMode.STACKED;
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return 0;
	}
}
