package an0nym8us.bukkit.magicCrafting.altar;

import java.util.HashMap;

import org.bukkit.inventory.ItemStack;

public class ShapedRecipeBuilder
{
	String[] lines;
	HashMap<Character, ItemStack> map;
	
	ItemStack result;
	
	public ShapedRecipeBuilder(ItemStack result, String... lines)
	{
		map = new HashMap<Character, ItemStack>();
		
		this.lines = lines;
		
		this.result = result;
		
		for(int i = 1; i < lines.length; i++)
		{
			if(lines[0].length() != lines[i].length())
			{
				throw new IllegalArgumentException("Recipe signature must be rectangle-shaped!");
			}
		}
	}
	
	public ShapedRecipeBuilder SetChar(char c, ItemStack item)
	{
		map.put(c, item);
		
		return this;
	}
	
	public ShapedAltarRecipe GetResult()
	{
		return new ShapedAltarRecipe(result, map, ToCharDiArray(lines));
	}
	
	private static final char[][] ToCharDiArray(String[] lines)
	{
		char[][] res = new char[lines.length][];
		
		for(int i = 0; i < lines.length; i++)
		{
			res[i] = lines[i].toCharArray();
		}
		
		return res;
	}
}
