package an0nym8us.bukkit.magicCrafting.altar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.bukkit.inventory.ItemStack;

public class ShapedAltarRecipe extends ShapelessAltarRecipe
{
	private static final long serialVersionUID = -4916870589033060961L;

	transient Map<Character, ItemStack> map;
	char[][] recipe;

	transient ItemStack[][] isPattern;
	transient int[] patternStartIndexes;

	public ShapedAltarRecipe(ItemStack result, Map<Character, ItemStack> map, char[][] charPattern)
	{
		this(null, 0, result, true, true, map, charPattern);
	}

	public ShapedAltarRecipe(ItemStack result, boolean checkOnlyType, boolean ignoreDurability,
			Map<Character, ItemStack> map, char[][] charPattern)
	{
		this(null, 0, result, checkOnlyType, ignoreDurability, map, charPattern);
	}

	public ShapedAltarRecipe(String recipeName, double recipePrice, ItemStack result, boolean checkOnlyType,
			boolean ignoreDurability, Map<Character, ItemStack> map, char[][] charPattern)
	{
		super(recipeName, recipePrice, result, CreatePattern(map, charPattern), checkOnlyType, ignoreDurability);

		this.map = map;
		this.recipe = charPattern;

		this.isPattern = Create2DPattern(map, charPattern);
	}

	@SuppressWarnings({ "unchecked" })
	private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
	{
		ois.defaultReadObject();

		super.pattern = _DeserializeISArray((Map<String, Object>[]) ois.readObject());
		result = _DeserializeIS((Map<String, Object>) ois.readObject());
		map = _DeserializeISMap((Map<Character, Map<String, Object>>) ois.readObject());
	}

	private void writeObject(ObjectOutputStream oos) throws IOException
	{
		oos.defaultWriteObject();

		oos.writeObject(_SerializeISArray(super.pattern));
		oos.writeObject(_SerializeIS(result));
		oos.writeObject(_SerializeISMap(map));
	}

	protected void Initialize()
	{
		isPattern = new ItemStack[recipe.length][];

		for (int i = 0; i < isPattern.length; i++)
		{
			isPattern[i] = new ItemStack[recipe[i].length];

			for (int j = 0; j < isPattern.length; j++)
			{
				isPattern[i][j] = map.get(recipe[i][j]);
			}
		}
	}

	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		ItemStack[][] ingredients = input.GetIngredients();

		int ingrI = -1;
		int ingrJ = -1;
		
		// CHECKING IF PATTERN IS PRESENT IN GIVEN INPUT;
		outloop: for (int i = 0; i < ingredients.length && isPattern.length + i <= ingredients.length; i++)
		{
			jloop: for (int j = 0; j < ingredients[i].length; j++)
			{
				for (int k = 0; k < isPattern.length; k++)
				{
					if (isPattern[k].length + j > ingredients[k + i].length)
					{
						continue jloop;
					}

					for (int l = 0; l < isPattern[k].length; l++)
					{
						if (MatchIS(isPattern[k][l], ingredients[k + i][l + j]) < 1)
						{
							continue jloop;
						}
					}
				}

				ingrI = i;
				ingrJ = j;

				break outloop;
			}
		}
		if (ingrI < 0 || ingrJ < 0)
		{
			return false;
		}

		// CHECKING IF NON-PATTERN FIELDS ARE NULL
		for (int i = 0; i < ingredients.length; i++)
		{
			for (int j = 0; j < ingredients[i].length; j++)
			{
				if ((i - ingrI < 0 || i - ingrI >= isPattern.length || j - ingrJ < 0
						|| j - ingrJ >= isPattern[i - ingrI].length) && !IsNull(ingredients[i][j]))
				{
					return false;
				}
			}
		}

		return true;
	}

	public int[] FindStartIndexes(ItemStack[][] ingredients)
	{
		for (int i = 0; i < ingredients.length; i++)
		{
			for (int j = 0; j < ingredients[i].length; j++)
			{
				if (!IsNull(ingredients[i][j])) { return new int[] { i, j }; }
			}
		}

		return null;
	}

	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		ItemStack[][] ingredients = input.GetIngredients();

		int ingrI = -1, ingrJ = -1;

		int minMultiplier = -1;

		outloop: for (int i = 0; i < ingredients.length && isPattern.length + i <= ingredients.length; i++)
		{
			jloop: for (int j = 0; j < ingredients[i].length; j++)
			{
				int internalMultiplier = Integer.MAX_VALUE;

				for (int k = 0; k < isPattern.length; k++)
				{
					if (isPattern[k].length + j > ingredients[k + i].length)
					{
						continue jloop;
					}

					for (int l = 0; l < isPattern[k].length; l++)
					{
						int currentMultiplier = MatchIS(isPattern[k][l], ingredients[k + i][l + j]);

						if (currentMultiplier < 1)
						{
							continue jloop;
						}

						if (currentMultiplier < internalMultiplier)
						{
							internalMultiplier = currentMultiplier;
						}
					}
				}

				minMultiplier = internalMultiplier;

				ingrI = i;
				ingrJ = j;

				break outloop;
			}
		}

		if (minMultiplier < 1) { return null; }

		for (int i = 0; i < isPattern.length; i++)
		{
			for (int j = 0; j < isPattern[i].length; j++)
			{
				if (ingredients[i + ingrI][j + ingrJ] == null)
				{
					continue;
				}

				if (isPattern[i][j].getAmount() * minMultiplier >= ingredients[i + ingrI][j + ingrJ].getAmount())
				{
					ingredients[i + ingrI][j + ingrJ] = null;
				}
				else
				{
					ingredients[i + ingrI][j + ingrJ].setAmount(ingredients[i + ingrI][j + ingrJ].getAmount()
							- isPattern[i][j].getAmount() * minMultiplier);
				}
			}
		}

		ItemStack res = result.clone();
		res.setAmount(res.getAmount() * minMultiplier);

		return new ItemAltarRecipeOutput(ingredients, res);
	}

	public static final char[][] StringToChar(String[] ar)
	{
		char[][] charRecipe = new char[ar.length][];

		for (int i = 0; i < ar.length; i++)
		{
			charRecipe[i] = ar[i].toCharArray();
		}

		return charRecipe;
	}

	public static final ItemStack[] CreatePattern(Map<Character, ItemStack> map, char[][] pattern)
	{
		List<ItemStack> res = new ArrayList<ItemStack>();

		for (int i = 0; i < pattern.length; i++)
		{
			for (int j = 0; j < pattern[i].length; j++)
			{
				res.add(map.containsKey(pattern[i][j]) ? map.get(pattern[i][j]) : null);
			}
		}

		return res.toArray(new ItemStack[res.size()]);
	}

	public static final ItemStack[][] Create2DPattern(Map<Character, ItemStack> map, char[][] pattern)
	{
		ItemStack[][] res = new ItemStack[pattern.length][];

		for (int i = 0; i < pattern.length; i++)
		{
			res[i] = new ItemStack[pattern[i].length];

			for (int j = 0; j < pattern[i].length; j++)
			{
				res[i][j] = map.containsKey(pattern[i][j]) ? map.get(pattern[i][j]) : null;
			}
		}

		return res;
	}
}
