package an0nym8us.bukkit.magicCrafting.altar;

import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class RepairAltarRecipe implements IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{	
	@Override
	public int GetRequiredAltarLevel()
	{
		return 1;
	}

	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		ItemStack buff = null;
		boolean secondItem = false;
		
		for(ItemStack is : AltarRecipe.MergeIngredients(input.GetIngredients()))
		{
			if(is == null)
			{
				continue;
			}
			
			//if(is.getType().getMaxDurability() == 0) { return false; }
			
			if(buff == null)
			{
				buff = is;
			}			
			else if(buff.getType().equals(is.getType()))
			{
				secondItem = true;
			}
			else
			{
				return false;
			}
		}
		
		return buff != null && secondItem;
	}

	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		ItemStack buff = null;
		
		int summedDurability = 0;
		int counter = 0;
		
		for(ItemStack is : input.GetMergedIngredients())
		{
			if(is == null)
			{
				continue;
			}
			
			if(is.getType().getMaxDurability() == 0) { return null; }
			
			if(buff == null)
			{
				buff = is.clone();
				
				buff.setItemMeta(Bukkit.getItemFactory().getItemMeta(buff.getType()));
			}
			else if(!buff.getType().equals(is.getType()))
			{
				return null;
			}
			
			summedDurability += is.getDurability();
			counter++;
		}
		
		buff.setDurability((short) (buff.getType().getMaxDurability() - Integer.min(buff.getType().getMaxDurability() * counter - summedDurability + Math.floorDiv(buff.getType().getMaxDurability(), 20), buff.getType().getMaxDurability())));
		
		return new ItemAltarRecipeOutput(input.GetEmptyIngredients(), buff);
	}
}
