package an0nym8us.bukkit.magicCrafting.altar;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.NMSProvider;
import an0nym8us.warmonger.NBTAbstractValue;
import an0nym8us.warmonger.Program;
import an0nym8us.warmonger.Warmonger;

public class RecipeItemStack implements Serializable, Cloneable
{
	private static final long serialVersionUID = 1L;

	transient NBTAbstractValue<?> itemStackStruct;
	
	Program program;
	
	public RecipeItemStack(NBTAbstractValue<?> itemStackStruct)
	{
		this(itemStackStruct, null);
	}
	
	public RecipeItemStack(NBTAbstractValue<?> itemStackStruct, Program program)
	{
		this.itemStackStruct = itemStackStruct;
		this.program = program;
	}
	
	public NBTAbstractValue<?> GetStructure()
	{
		return itemStackStruct;
	}
	
	public boolean HasProgram()
	{
		return program != null;
	}
	
	public Program GetProgram()
	{
		return program;
	}
	
	public boolean DoesMatch(ItemStack itemStack, Map<String, Object> params)
	{
		return itemStackStruct.DoesMatch(itemStack, params);
	}
	
	public boolean DoesMatch(Object nbtTagCompound, Map<String, Object> params)
	{
		return itemStackStruct.DoesMatch(nbtTagCompound, params);
	}
	
	public boolean MatchAndDecrease(Object nbtTagCompound, Map<String, Object> params)
	{
		if(DoesMatch(nbtTagCompound, params))
		{
			ItemStack is = ISBuilder.DeserializeIS(nbtTagCompound);
			
			int decreasedValue = (int) itemStackStruct.GetNBTValue("item.Count").GetValue(params);
			
			if(is.getAmount() > decreasedValue)
			{
				
			}
			else
			{
				is = new ItemStack(Material.AIR);
			}
		}
		
		return false;
	}
	
	private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
	{
		ois.defaultReadObject();
		
		itemStackStruct = (NBTAbstractValue<?>) Warmonger.Read(ois);
	}
	
	private void writeObject(ObjectOutputStream oos) throws IOException
	{
		oos.defaultWriteObject();
		
		itemStackStruct.Write(oos);
	}
	
	/*public ItemStack Execute(ItemStack in, Map<String, Object> params)
	{
		if(program != null && DoesMatch(in, params))
		{
			program.Execute(params);
		}
		
		return (ItemStack)params.get("is");
	}*/
	
	public ItemStack GenerateIS(Map<String, Object> params)
	{
		return ISBuilder.DeserializeIS(itemStackStruct.PrepareNBTBase(params));
	}
	
	public static ItemStack[] GenerateISArray(RecipeItemStack[] ris, Map<String, Object> params)
	{
		ItemStack[] res = new ItemStack[ris.length];
		
		for(int i = 0; i < ris.length; i++)
		{
			res[i] = ris[i].GenerateIS(params);
		}
		
		return res;
	}
	
	public static boolean SerializeIS(ItemStack is, OutputStream os)
	{
		try
		{
			Class<?> _craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftItemStack");
			Class<?> _itemStack = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".ItemStack");
			Class<?> _nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagCompound");
			Class<?> _nbtCompressedStreamTools = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools");

			Object tag = _nbtTagCompound.newInstance();

			Method m0 = _itemStack.getDeclaredMethod("save", _nbtTagCompound);
			m0.setAccessible(true);
			Method m1 = _craftItemStack.getDeclaredMethod("asNMSCopy", ItemStack.class);
			m1.setAccessible(true);
			Method m2 = _nbtCompressedStreamTools.getDeclaredMethod("a", _nbtTagCompound, OutputStream.class);
			m2.setAccessible(true);

			tag = m0.invoke(m1.invoke(null, is), tag);

			m2.invoke(null, tag, os);

			return true;
		}
		catch (ClassNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InstantiationException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return false;
	}
	
	public static ItemStack DeserializeIS(InputStream is)
	{
		try
		{
			Class<?> _craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftItemStack");
			Class<?> _itemStack = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".ItemStack");
			Class<?> _nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagCompound");
			Class<?> _nbtCompressedStreamTools = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools");

			Method m0 = _nbtCompressedStreamTools.getDeclaredMethod("a", InputStream.class);
			m0.setAccessible(true);
			Method m1 = _craftItemStack.getDeclaredMethod("asBukkitCopy", _itemStack);
			m1.setAccessible(true);
			Method m2 = _itemStack.getDeclaredMethod("createStack", _nbtTagCompound);
			m2.setAccessible(true);

			Object tag = m0.invoke(null, is);

			ItemStack res = (ItemStack) m1.invoke(null, m2.invoke(null, tag));
			
			return res;
		}
		catch (ClassCastException ex)
		{
			Bukkit.getLogger().warning("Invalid serializedIS-NBT type in serialized item");

			return null;
		}
		catch (ClassNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}
	
	public static NBTAbstractValue<?>[] Convert(RecipeItemStack[] ris)
	{
		NBTAbstractValue<?>[] res = new NBTAbstractValue<?>[ris.length];
		
		for(int i = 0; i < ris.length; i++)
		{
			res[i] = ris[i].GetStructure();
		}
		
		return res;
	}
}
