package an0nym8us.bukkit.magicCrafting.altar;

import java.util.UUID;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;

import an0nym8us.cyanide.ICreationHandler;
import an0nym8us.cyanide.ICreationInterface;

public class RecipeItemArrayCreatorBlockStructure extends AltarStructure implements ICreationInterface<RecipeItemStack[]>
{
	int currentIndex;
	int resultTask = -1;
	
	RecipeItemStack[] recipeItemStacks;
	
	ICreationHandler<RecipeItemStack[]> creationHandler;
	
	public RecipeItemArrayCreatorBlockStructure(Location loc, UUID owner, ICreationHandler<RecipeItemStack[]> creationHandler)
	{
		this(loc, owner, 1, creationHandler);
	}

	public RecipeItemArrayCreatorBlockStructure(Location loc, UUID owner, int level, ICreationHandler<RecipeItemStack[]> creationHandler)
	{
		super(loc, owner, level);
	}
	
	public void Clean()
	{
		if (isDisposed) { return; }

		//this.currentRecipe = null;

		//this.SetResultHologram(null);

		int size = (2 * level + 1) * (2 * level + 1);

		for (int i = 0; i < size; i++)
		{
			this.SetItem((ItemStack)null, i);
		}
	}
	
	public boolean HasIngredients()
	{
		for (RecipeItemStack is : recipeItemStacks)
		{
			if (is != null) { return true; }
		}

		return false;
	}
	
	public boolean SetItem(RecipeItemStack ris, int index)
	{
		ItemStack is = ris.GenerateIS(null);
		
		if(!SetItem(is, index)) { return false; }
		
		recipeItemStacks[index] = ris;
		
		UpdateItemHologram(index);
		
		return true;
	}
	
	@Override
	public boolean SetItem(ItemStack is, int index)
	{
		if (isDisposed || index < 0 || index >= itemStacks.length) { return false; }

		if (is == null || is.getType().equals(Material.AIR))
		{
			itemStacks[index] = null;

			items[index].clearLines();
		}
		else
		{
			boolean similar = is.isSimilar(this.itemStacks[index]);

			itemStacks[index] = is;

			if (similar)
			{
				if (is.getType() != Material.AIR && is.getAmount() != 0)
				{
					if (items[index].size() > 0)
					{
						items[index].removeLine(0);
						items[index].insertTextLine(0, Integer.toString(is.getAmount()));
					}
					else
					{
						items[index].appendTextLine(Integer.toString(is.getAmount()));
						items[index].appendItemLine(is);
					}
				}
			}
			else
			{
				items[index].clearLines();

				if (is.getType() != Material.AIR && is.getAmount() != 0)
				{
					items[index].appendTextLine(Integer.toString(is.getAmount()));
					items[index].appendItemLine(is);
				}
			}
		}

		return true;
	}
	
	@Override
	public boolean Craft()
	{
		creationHandler.onCreationHandle(this);
		
		return true;
	}
	
	public void UpdateItemHologram(int index)
	{
		ItemStack template = ((ItemLine)items[index].getLine(items[index].size())).getItemStack();
		
		//ItemStack generatedIS = this.
	}

	@Override
	public boolean BeginCreation()
	{
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public RecipeItemStack[] Return()
	{
		// TODO Auto-generated method stub
		return null;
	}
}
