package an0nym8us.bukkit.magicCrafting.altar;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import org.bukkit.map.MapView.Scale;

public class MapExtendAltarRecipe implements IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		boolean map = false;

		int counter = 0;

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (is.getType().equals(Material.MAP))
			{
				if (map) { return false; }

				map = true;

				continue;
			}
			else if (is.getType().equals(Material.PAPER))
			{
				counter++;
			}
			
			return false;
		}

		return map && counter == 8;
	}

	@SuppressWarnings("deprecation")
	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		ItemStack res = null;

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (is.getType().equals(Material.MAP))
			{
				res = is.clone();

				continue;
			}

			if (!is.getType().equals(Material.PAPER)) { return null; }
		}

		if (res == null) { return null; }

		MapView oldMv = Bukkit.getMap(res.getDurability());
		MapView newMv = Bukkit.createMap(oldMv.getWorld());

		newMv.setCenterX(oldMv.getCenterX());
		newMv.setCenterZ(oldMv.getCenterZ());

		newMv.setScale(Scale.valueOf((byte) (oldMv.getScale().getValue() < 1 ? 1
				: oldMv.getScale().getValue() > 3 ? 4 : (oldMv.getScale().getValue() + 1))));

		res.setDurability(newMv.getId());
		// mv.setScale(Scale.valueOf((byte)(mv.getScale().getValue() < 1 ? 1 :
		// mv.getScale().getValue() > 3 ? 4 : (mv.getScale().getValue() + 1))));

		return new ItemAltarRecipeOutput(input.GetEmptyIngredients(), res);
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return 1;
	}
}