package an0nym8us.bukkit.magicCrafting.altar;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class MapCloneAltarRecipe implements IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		boolean map = false;
		
		int emptyMapCounter = 0;
		
		for (ItemStack is : input.GetMergedIngredients())
		{
			if(is == null) { continue; }
			
			if (is.getType().equals(Material.MAP))
			{
				if (map) { return false; }
				
				map = true;
				
				continue;
			}
			else if (is.getType().equals(Material.EMPTY_MAP))
			{
				emptyMapCounter++;
			}
			else
			{
				return false;
			}
		}
		
		return map && emptyMapCounter != 0;
	}
	
	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		int counter = 1;
		
		ItemStack map = null;
		
		for (ItemStack is : input.GetMergedIngredients())
		{
			if(is == null) { continue; }

			if(is.getType().equals(Material.MAP))
			{
				map = is.clone();
			}
			
			if (is.getType().equals(Material.EMPTY_MAP))
			{
				counter += is.getAmount();
			}
		}
		
		if(map == null) { return null; }
		
		ItemStack[] res = new ItemStack[counter];
		
		for(int i = 0; i < res.length; i++)
		{
			res[i] = map.clone();
		}
		
		return new ItemAltarRecipeOutput(input.GetEmptyIngredients(), res);
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return 1;
	}
}
