package an0nym8us.bukkit.magicCrafting.altar;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

import com.comphenix.protocol.wrappers.EnumWrappers.Particle;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;

import an0nym8us.bukkit.magicCrafting.Direction;
import an0nym8us.bukkit.magicCrafting.EffectPlayer;
import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.cyanide.ICreationHandler;

public class ItemArrayCreatorBlockStructure
		implements IItemAltarCreator
{
	private static final boolean OVERSIZED_IS = false;
	public static final int START_TICKS = 20;
	private static final int MAX_LEVEL = 256;

	ICreationHandler<ItemStack[][]> creationHandler;

	final int level;

	Location loc;

	Hologram[][] itemHolos;
	ItemStack[][] itemStacks;

	Vector[] locs;
	Vector[] offsets;

	boolean isDisposed = false;

	Direction direction;

	UUID owner;
	
	int ticksRemaining = -1;

	public ItemArrayCreatorBlockStructure(Location loc, UUID owner, Direction dir, int level,
			ICreationHandler<ItemStack[][]> creationHandler)
	{
		this.loc = loc.getBlock().getLocation();
		this.owner = owner;
		this.direction = dir;
		this.level = level;
		this.creationHandler = creationHandler;

		itemHolos = new Hologram[2 * level + 1][];
		itemStacks = new ItemStack[2 * level + 1][];

		for (int i = 0; i < itemHolos.length; i++)
		{
			itemHolos[i] = new Hologram[itemHolos.length];
			itemStacks[i] = new ItemStack[itemStacks.length];
		}

		for (int i = 0; i < 2 * level + 1; i++)
		{

			for (int j = 0; j < 2 * level + 1; j++)
			{
				itemHolos[i][j] = HologramsAPI.createHologram(Main.GetInstance(), GetHoloLocation(i, j));
			}
		}

		locs = new Vector[] { new Vector(loc.getX() + 0.5, loc.getY() + 1, loc.getZ() - GetLevel()),
				new Vector(loc.getX() - GetLevel(), loc.getY() + 1, loc.getZ() + 0.5),
				new Vector(loc.getX() + 0.5, loc.getY() + 1, loc.getZ() + GetLevel() + 1),
				new Vector(loc.getX() + GetLevel() + 1, loc.getY() + 1, loc.getZ() + 0.5) };

		offsets = new Vector[] { new Vector(0.75 * GetLevel(), 0, 0), new Vector(0, 0, 0.75 * GetLevel()),
				new Vector(0.75 * GetLevel(), 0, 0), new Vector(0, 0, 0.75 * GetLevel()) };
	}

	public static ItemArrayCreatorBlockStructure Create(Location loc, UUID owner,
			ICreationHandler<ItemStack[][]> creationHandler)
	{
		int maxLevel = GetMaxLevel(loc);
		if (maxLevel < 0) { return null; }

		return Create(loc, owner, GetDirection(loc, maxLevel), maxLevel, creationHandler);
	}
	
	public static ItemArrayCreatorBlockStructure Create(Location loc, UUID owner, int forcedLevel,
			ICreationHandler<ItemStack[][]> creationHandler)
	{
		return Create(loc, owner, GetDirection(loc, forcedLevel), forcedLevel, creationHandler);
	}

	public static ItemArrayCreatorBlockStructure Create(Location loc, UUID owner, Direction dir, int forcedLevel,
			ICreationHandler<ItemStack[][]> creationHandler)
	{
		return new ItemArrayCreatorBlockStructure(loc, owner, dir, forcedLevel, creationHandler);
	}

	@Override
	public void Dispose()
	{
		for (int i = 0; i < itemHolos.length; i++)
		{
			for (int j = 0; j < itemHolos.length; j++)
			{
				if (itemStacks[i][j] != null && itemStacks[i][j].getType() != Material.AIR)
				{
					loc.getWorld().dropItem(GetHoloLocation(i, j), itemStacks[i][j]).setVelocity(new Vector(0, 0, 0));
				}

				itemHolos[i][j].delete();
			}
		}

		isDisposed = true;
	}

	protected Location GetHoloLocation(int i, int j)
	{
		return GetHoloLocation(i, j, 1);
	}

	protected Location GetHoloLocation(int i, int j, double scale)
	{
		return direction.GetLoc((i - level) * scale, (j - level) * scale, loc).add(0.5, 2, 0.5);
	}

	public int[] GetIndex(Location loc)
	{
		int[] indexes = direction.GetIndex(loc.getBlockX(), loc.getBlockZ(), this.loc.getBlockX(),
				this.loc.getBlockZ());

		indexes[0] += level;
		indexes[1] += level;

		return indexes;
	}

	protected int[] GetLocXZ(int i, int j)
	{
		return direction.GetLocXZ(i - level, j - level, this.loc.getBlockX(), this.loc.getBlockZ());
	}

	protected Location GetLoc(int i, int j)
	{
		int[] loc = direction.GetLocXZ(i - level, j - level, this.loc.getBlockX(), this.loc.getBlockZ());

		return new Location(this.loc.getWorld(), loc[0], this.loc.getBlockY(), loc[1]);
	}

	public static int GetMaxLevel(Location loc)
	{
		Block block = loc.getBlock();
		int x = loc.getBlockX(), y = loc.getBlockY(), z = loc.getBlockZ();

		if (!block.getType().equals(AltarStructure.CENTER_MAT)) { return -1; }

		int lvl = 1;

		outloop: for (; lvl <= MAX_LEVEL; lvl++)
		{
			boolean matToggle = false;

			for (int j = -lvl; j < lvl + 1; j++)
			{
				if (!loc.getWorld().getBlockAt(x + j, y, z - lvl).getType()
						.equals(matToggle ? AltarStructure.SECOND_MAT : AltarStructure.FIRST_MAT)
						|| !loc.getWorld().getBlockAt(x + j, y, z + lvl).getType()
								.equals(matToggle ? AltarStructure.SECOND_MAT : AltarStructure.FIRST_MAT))
				{
					break outloop;
				}

				matToggle = !matToggle;
			}

			for (int i = -lvl + 1; i < lvl; i++)
			{
				if (!loc.getWorld().getBlockAt(x - lvl, y, z + i).getType()
						.equals(matToggle ? AltarStructure.SECOND_MAT : AltarStructure.FIRST_MAT)
						|| !loc.getWorld().getBlockAt(x + lvl, y, z + i).getType()
								.equals(matToggle ? AltarStructure.SECOND_MAT : AltarStructure.FIRST_MAT))
				{
					break outloop;
				}

				matToggle = !matToggle;
			}
		}

		return GetDirection(loc, lvl - 1) == null ? -1 : lvl - 1;
	}

	public static Direction GetDirection(Location loc, int lvl)
	{
		for (Direction dir : Direction.values())
		{
			if (dir.GetLoc(-lvl - 1, 0, loc).getBlock().getType().equals(AltarStructure.CENTER_MAT)) { return dir; }
		}

		return null;
	}

	@Override
	public boolean HasOwner()
	{
		return owner != null;
	}

	@Override
	public UUID GetOwner()
	{
		return owner;
	}

	@Override
	public boolean IsDisposed()
	{
		return isDisposed;
	}

	public void Clean()
	{
		if (isDisposed) { return; }

		for (int i = 0; i < 2 * level + 1; i++)
		{
			for (int j = 0; j < 2 * level + 1; j++)
			{
				this.SetItem(null, i, j);
			}
		}
	}

	public int GetLevel()
	{
		return level;
	}

	public boolean IsEmpty()
	{
		for (int i = 0; i < itemStacks.length; i++)
		{
			for (int j = 0; j < itemStacks[i].length; j++)
			{
				if (itemStacks[i][j] != null) { return false; }
			}
		}

		return true;
	}

	public ItemStack GetItem(int index)
	{
		return index >= 0 && index < (2 * GetLevel() + 1) * (2 * GetLevel() + 1)
				? itemStacks[index % (2 * GetLevel() + 1)][index / (2 * GetLevel() + 1)] : null;
	}

	protected ItemStack GetItem(int i, int j)
	{
		return i >= 0 && i < (2 * GetLevel() + 1) && j >= 0 && j < (2 * GetLevel() + 1) ? itemStacks[i][j] : null;
	}

	public boolean SetItem(ItemStack is, int index)
	{
		return SetItem(is, index % (2 * GetLevel() + 1), index / (2 * GetLevel() + 1));
	}

	protected boolean SetItem(ItemStack is, int i, int j)
	{
		if (isDisposed || i < 0 || i >= (2 * GetLevel() + 1) || j < 0 || j >= (2 * GetLevel() + 1)) { return false; }

		if (is == null || is.getType().equals(Material.AIR))
		{
			itemStacks[i][j] = null;
			itemHolos[i][j].clearLines();

			return true;
		}

		if (is.isSimilar(itemStacks[i][j]) && itemHolos[i][j].size() > 0)
		{
			itemHolos[i][j].removeLine(0);
			itemHolos[i][j].insertTextLine(0, Integer.toString(is.getAmount()));
		}
		else
		{
			itemHolos[i][j].clearLines();
			
			itemHolos[i][j].appendTextLine(Integer.toString(is.getAmount()));
			itemHolos[i][j].appendItemLine(is);
		}

		itemStacks[i][j] = is;

		return true;
	}

	public boolean SetArray(ItemStack[][] array)
	{
		if (array.length < 2 * level + 1) { return false; }

		for (int i = 0; i < 2 * level + 1; i++)
		{
			if (array[i].length < 2 * level + 1) { return false; }

			for (int j = 0; j < 2 * level + 1; j++)
			{
				itemStacks[i][j] = array[i][j];

				itemHolos[i][j].clearLines();

				if (itemStacks[i][j] != null)
				{
					itemHolos[i][j].appendTextLine(Integer.toString(itemStacks[i][j].getAmount()));
					itemHolos[i][j].appendItemLine(itemStacks[i][j]);
				}
			}
		}

		return true;
	}

	public void SetScale(double scale)
	{
		for (int i = 0; i < itemHolos.length; i++)
		{
			for (int j = 0; j < itemHolos.length; j++)
			{
				itemHolos[i][j].teleport(GetHoloLocation(i, j, scale));
			}
		}
	}

	public boolean HasIngredients()
	{
		for (ItemStack[] is0 : itemStacks)
		{
			for (ItemStack is1 : is0)
			{
				if (is1 != null) { return true; }
			}
		}

		return false;
	}

	public boolean DoesBelong(Location loc)
	{
		return (loc.getBlockZ() - this.loc.getBlockZ() >= -level && loc.getBlockZ() - this.loc.getBlockZ() <= level)
				&& loc.getBlockY() == this.loc.getBlockY() && (loc.getBlockX() - this.loc.getBlockX() >= -level
						&& loc.getBlockX() - this.loc.getBlockX() <= level) || loc.equals(direction.GetLoc(-level - 1, 0, this.loc));
	}
	
	public boolean IsAnArray(Location loc)
	{
		return (loc.getBlockZ() - this.loc.getBlockZ() >= -level && loc.getBlockZ() - this.loc.getBlockZ() <= level)
				&& loc.getBlockY() == this.loc.getBlockY() && (loc.getBlockX() - this.loc.getBlockX() >= -level
						&& loc.getBlockX() - this.loc.getBlockX() <= level);
	}

	@Override
	public boolean BeginCreation()
	{
		ticksRemaining = START_TICKS;
		
		return true;
	}

	public ItemStack[][] Return()
	{
		return itemStacks;
	}

	@Override
	public boolean HasCreationHandler()
	{
		return creationHandler != null;
	}

	@Override
	public ICreationHandler<ItemStack[][]> GetCreationHandler()
	{
		return creationHandler;
	}

	@Override
	public boolean SetCreationHandler(ICreationHandler<ItemStack[][]> creationHandler)
	{
		this.creationHandler = creationHandler;

		return true;
	}

	public boolean Tick()
	{
		if (IsDisposed()) { return false; }
		
		EffectPlayer.PlayVisualEffect(AltarStructure.BORDER_PARTICLE.getId(), loc.getWorld(), locs[0], offsets[0],
				AltarStructure.BORDER_PARTICLE.getDataLength(), 5 * GetLevel());
		EffectPlayer.PlayVisualEffect(AltarStructure.BORDER_PARTICLE.getId(), loc.getWorld(), locs[1], offsets[1],
				AltarStructure.BORDER_PARTICLE.getDataLength(), 5 * GetLevel());
		EffectPlayer.PlayVisualEffect(AltarStructure.BORDER_PARTICLE.getId(), loc.getWorld(), locs[2], offsets[2],
				AltarStructure.BORDER_PARTICLE.getDataLength(), 5 * GetLevel());
		EffectPlayer.PlayVisualEffect(AltarStructure.BORDER_PARTICLE.getId(), loc.getWorld(), locs[3], offsets[3],
				AltarStructure.BORDER_PARTICLE.getDataLength(), 5 * GetLevel());
		
		if (ticksRemaining >= 5)
		{
			SetScale(((double) ticksRemaining - 5) / (START_TICKS - 5));
		}
		else if (ticksRemaining > 1)
		{
			EffectPlayer.PlayVisualEffect(Particle.CRIT.getId(), loc.getWorld(), loc.getX() + 0.5,
					loc.getY() + 1.5, loc.getZ() + 0.5, new Vector(0.05, 0.05, 0.05), 1.f, 50);
		}
		else if (ticksRemaining == 1)
		{
			CallCreationHandle();
			
			this.SetScale(1);
		}
		else
		{
			return true;
		}
		
		ticksRemaining--;

		return true;
	}

	@SuppressWarnings("deprecation")
	@Override
	public boolean Click(Location loc, Player player, boolean isLeftClick)
	{
		if (!this.IsAnArray(loc)) { return false; }

		int[] index = GetIndex(loc);

		ItemStack altarIS = GetItem(index[0], index[1]);

		Bukkit.getLogger()
				.info("AltarIS: " + (altarIS == null ? "null" : altarIS.getType().name() + " " + altarIS.getAmount()));
		ItemStack inputIS = player.getItemInHand();

		outblock: if (!isLeftClick)
		{
			if (player.isSneaking()) // WHOLE STACK
			{
				if (inputIS == null || inputIS.getAmount() < 1)
				{
					if (altarIS == null || altarIS.getAmount() < 1)
					{
						break outblock;
					}
					else
					{
						if(altarIS.getAmount() > altarIS.getMaxStackSize())
						{
							ItemStack is = altarIS.clone();
							is.setAmount(altarIS.getMaxStackSize());
							player.getInventory().addItem(is);
							
							altarIS.setAmount(altarIS.getAmount() - altarIS.getMaxStackSize());
						}
						else
						{
							player.getInventory().addItem(altarIS);
	
							altarIS = null;
						}
					}
				}
				else
				{
					if (altarIS == null)
					{
						if(!removeItem(player, inputIS)) { return true; }
						
						altarIS = inputIS;
					}
					else
					{
						if (altarIS.isSimilar(inputIS))
						{
							if (altarIS.getAmount() < GetMaxStackSize(altarIS))
							{
								if (altarIS.getAmount() + inputIS.getAmount() <= GetMaxStackSize(altarIS))
								{
									altarIS.setAmount(altarIS.getAmount() + inputIS.getAmount());

									removeItem(player, inputIS);
								}
								else
								{
									int takenAmount = GetMaxStackSize(altarIS) - altarIS.getAmount();

									altarIS.setAmount(GetMaxStackSize(altarIS));

									inputIS.setAmount(inputIS.getAmount() - takenAmount);
								}
							}
							else
							{
								player.getInventory().addItem(altarIS);

								altarIS = null;
							}
						}
						else
						{
							if(!removeItem(player, inputIS)) { return true; }
							
							player.getInventory().addItem(altarIS);

							altarIS = inputIS;
						}
					}
				}
			}
			else
			{
				if (inputIS == null || inputIS.getAmount() < 1)
				{
					if (altarIS == null || altarIS.getAmount() < 1)
					{
						break outblock;
					}
					else
					{
						if (altarIS.getAmount() > 1)
						{
							ItemStack buff = altarIS.clone();
							buff.setAmount(1);

							player.getInventory().addItem(buff);

							altarIS.setAmount(altarIS.getAmount() - 1);
						}
						else // CAN BE ONLY 1
						{
							player.getInventory().addItem(altarIS);

							altarIS = null;
						}
					}
				}
				else
				{
					if (altarIS == null)
					{
						if (inputIS.getAmount() > 1)
						{
							altarIS = inputIS.clone();
							altarIS.setAmount(1);
							
							inputIS.setAmount(inputIS.getAmount() - 1);
						}
						else // CAN BE ONLY 1
						{
							if(!removeItem(player, inputIS)) { return true; }
							
							altarIS = inputIS.clone();
							altarIS.setAmount(1);
						}
					}
					else
					{
						if (altarIS.isSimilar(inputIS))
						{
							if (altarIS.getAmount() < GetMaxStackSize(altarIS))
							{
								altarIS.setAmount(altarIS.getAmount() + 1);

								if (inputIS.getAmount() > 1)
								{
									inputIS.setAmount(inputIS.getAmount() - 1);
								}
								else // CAN BE ONLY 1
								{
									if(!removeItem(player, inputIS)) { return true; }
								}
							}
							else
							{
								break outblock;
							}
						}
						else
						{
							if (inputIS.getAmount() > 1)
							{
								player.getInventory().addItem(altarIS);
								
								altarIS = inputIS.clone();
								altarIS.setAmount(1);

								inputIS.setAmount(inputIS.getAmount() - 1);
							}
							else
							{
								if(!removeItem(player, inputIS)) { return true; }
								
								player.getInventory().addItem(altarIS);
								
								altarIS = inputIS;
							}
						}
					}
				}
			}
		}

		this.SetItem(altarIS, index[0], index[1]);

		return true;
	}

	// Returns max stack size predicted for specified item stack. This proxy
	// allows to implement oversized itemstacks into this struct.
	protected int GetMaxStackSize(ItemStack is)
	{
		return OVERSIZED_IS ? Integer.MAX_VALUE : is.getMaxStackSize();
	}

	private boolean removeItem(Player p, ItemStack is)
	{
		int isAmount = is.getAmount();
		ItemStack[] content = p.getInventory().getContents();

		for (int i = 0; i < content.length; i++)
		{
			if (content[i] != null && content[i].isSimilar(is))
			{
				isAmount -= content[i].getAmount();
			}
		}

		if (isAmount > 0) { return false; }

		isAmount = is.getAmount();
		for (int i = 0; i < content.length && 0 < isAmount; i++)
		{
			if (content[i] != null && content[i].isSimilar(is))
			{
				if (isAmount < content[i].getAmount())
				{
					content[i].setAmount(content[i].getAmount() - isAmount);

					isAmount = 0;
				}
				else
				{
					isAmount -= content[i].getAmount();

					content[i] = new ItemStack(Material.AIR);
				}
			}
		}
		
		p.getInventory().setContents(content);
		
		p.updateInventory();

		return true;
	}

	@Override
	public boolean IsInProgress()
	{
		return ticksRemaining > 0;
	}
}
