package an0nym8us.bukkit.magicCrafting.altar;

import java.util.UUID;

import org.bukkit.inventory.ItemStack;

public class ItemAltarRecipeInput
{
	public UUID executor;
	IAltarStructure altar;
	ItemStack[][] ingredients;

	public ItemAltarRecipeInput(UUID executor, IAltarStructure altar, ItemStack[][] ingredients)
	{
		this.executor = executor;
		this.altar = altar;
		this.ingredients = ingredients;
	}

	public ItemStack[][] GetIngredients()
	{
		return ingredients;
	}

	public ItemStack[] GetMergedIngredients()
	{
		return AltarRecipe.MergeIngredients(ingredients);
	}

	public ItemStack[][] GetEmptyIngredients()
	{
		ItemStack[][] res = new ItemStack[ingredients.length][];

		for (int i = 0; i < ingredients.length; i++)
		{
			res[i] = new ItemStack[ingredients[i].length];
		}

		return res;

	}
}
