package an0nym8us.bukkit.magicCrafting.altar;

import java.lang.reflect.Field;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.NMSProvider;

public class BookCloneAltarRecipe implements IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		boolean writtenBook = false;

		int counter = 0;

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (is.getType().equals(Material.WRITTEN_BOOK))
			{
				if (writtenBook) { return false; }

				if (GetGeneration(is) > 1) { return false; }

				writtenBook = true;

				continue;
			}
			else if (is.getType().equals(Material.BOOK_AND_QUILL))
			{
				counter++;
			}
			else
			{
				return false;
			}
		}

		return writtenBook && counter != 0;
	}

	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		int counter = 0;

		ItemStack book = null;

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (is.getType().equals(Material.WRITTEN_BOOK))
			{
				book = is.clone();
			}

			if (is.getType().equals(Material.BOOK_AND_QUILL))
			{
				counter += is.getAmount();
			}
		}

		if (book == null || !book.hasItemMeta() || GetGeneration(book) > 1) { return null; }

		book.setAmount(counter);

		book = SetGeneration(book, GetGeneration(book) + 1);

		ItemStack[] res = new ItemStack[counter + 1];

		res[0] = book;
		res[1] = SetGeneration(book.clone(), GetGeneration(book) + 1);

		for (int i = 2; i < res.length; i++)
		{
			res[i] = res[1].clone();
		}

		return new ItemAltarRecipeOutput(input.GetEmptyIngredients(), res);
	}

	public static int GetGeneration(ItemStack is)
	{
		if (!is.getType().equals(Material.WRITTEN_BOOK) || !is.hasItemMeta()) { return -1; }

		try
		{
			Class<?> _craftBookMeta = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftMetaBook");

			Field f = _craftBookMeta.getDeclaredField("generation");
			f.setAccessible(true);

			return (int) f.get((BookMeta) is.getItemMeta());
		}
		catch (ClassNotFoundException | IllegalArgumentException | IllegalAccessException | NoSuchFieldException
				| SecurityException e)
		{
			Bukkit.getServer().getLogger().warning(
					"This plugin is incompatible with current server build! Contact with plugin author if this should not appear.");

			e.printStackTrace();
		}

		return -1;
	}

	protected ItemStack SetGeneration(ItemStack is, int newValue)
	{
		if (!is.getType().equals(Material.WRITTEN_BOOK) || !is.hasItemMeta()) { return is; }

		try
		{
			Class<?> _craftBookMeta = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftMetaBook");

			Field f = _craftBookMeta.getDeclaredField("generation");
			f.setAccessible(true);

			BookMeta bm = (BookMeta) is.getItemMeta();
			f.set(bm, newValue);

			is.setItemMeta(bm);
		}
		catch (ClassNotFoundException | IllegalArgumentException | IllegalAccessException | NoSuchFieldException
				| SecurityException e)
		{
			Bukkit.getServer().getLogger().warning(
					"This plugin is incompatible with current server build! Contact with plugin author if this should not appear.");

			e.printStackTrace();
		}

		return is;
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return 1;
	}
}
