package an0nym8us.bukkit.magicCrafting.altar;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ArmorDyeAltarRecipe implements IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	@Override
	public boolean DoesMatch(ItemAltarRecipeInput input)
	{
		boolean armorPiece = false;

		int counter = 0;

		ItemMeta templateMeta = Bukkit.getItemFactory().getItemMeta(Material.LEATHER_CHESTPLATE);

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (Bukkit.getItemFactory().isApplicable(templateMeta, is))
			{
				if (armorPiece) { return false; }

				armorPiece = true;
			}
			else if (!is.getType().equals(Material.INK_SACK)) { return false; }
		}

		return armorPiece && counter != 0;
	}

	@Override
	public ItemAltarRecipeOutput GetResult(ItemAltarRecipeInput input)
	{
		ItemStack armorPiece = null;

		List<Color> colors = new ArrayList<Color>();

		for (ItemStack is : input.GetMergedIngredients())
		{
			if (is == null)
			{
				continue;
			}

			if (Bukkit.getItemFactory().isApplicable(Bukkit.getItemFactory().getItemMeta(Material.LEATHER_CHESTPLATE),
					is))
			{
				if (armorPiece != null) { return null; }

				armorPiece = is.clone();

				continue;
			}

			if (is.getType().equals(Material.INK_SACK))
			{
				colors.add(GetColor(is));
			}
			else
			{
				return null;
			}
		}

		LeatherArmorMeta lam = armorPiece.hasItemMeta() ? (LeatherArmorMeta) armorPiece.getItemMeta()
				: (LeatherArmorMeta) Bukkit.getItemFactory().getItemMeta(armorPiece.getType());

		if (!lam.getColor().equals(Bukkit.getItemFactory().getDefaultLeatherColor()))
		{
			colors.add(lam.getColor());
		}

		Color resColor = CalculateNewColor(colors.toArray(new Color[colors.size()]));
		lam.setColor(resColor);
		armorPiece.setItemMeta(lam);

		return new ItemAltarRecipeOutput(input.GetEmptyIngredients(), armorPiece);
	}

	private static Color CalculateNewColor(Color... colors)
	{
		int totalRed = 0, totalGreen = 0, totalBlue = 0, totalMaximum = 0;

		for (Color c : colors)
		{
			totalRed += c.getRed();
			totalGreen += c.getGreen();
			totalBlue += c.getBlue();
			totalMaximum += Integer.max(Integer.max(c.getRed(), c.getGreen()), c.getBlue());
		}

		int avRed = totalRed / colors.length;
		int avGreen = totalGreen / colors.length;
		int avBlue = totalBlue / colors.length;
		int avMaximum = totalMaximum / colors.length;

		int maxAv = Integer.max(Integer.max(avRed, avGreen), avBlue);
		int fact = avMaximum / maxAv;

		return Color.fromRGB(avRed * fact, avGreen * fact, avBlue * fact);
	}

	@SuppressWarnings("deprecation")
	private static Color GetColor(ItemStack is)
	{
		if (!is.getType().equals(Material.INK_SACK)) { return Color.WHITE; }

		return DyeColor.getByDyeData((byte) is.getDurability()).getColor();
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return 1;
	}
}
