package an0nym8us.bukkit.magicCrafting.altar;

import java.util.List;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

import com.comphenix.protocol.wrappers.EnumWrappers.Particle;
import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.cyanide.ICreationHandler;
import an0nym8us.cyanide.ICreationInterface;

public class AltarStructure implements IAltarStructure, ITickable, ICreationHandler<ItemStack[][]>
{
	public static Particle BORDER_PARTICLE = Particle.FLAME;

	public static Material CENTER_MAT = Material.REDSTONE_BLOCK;
	public static Material FIRST_MAT = Material.DIAMOND_BLOCK;
	public static Material SECOND_MAT = Material.EMERALD_BLOCK;

	public static final int START_TICKS = 20;

	IItemAltarCreator itemArray;

	Hologram hologram;

	ItemStack result;
	Hologram resultHolo;
	
	Location altarloc;
	
	protected AltarStructure(Location loc, UUID owner, IItemAltarCreator itemArray)
	{
		this.altarloc = loc;
		this.itemArray = itemArray;

		hologram = HologramsAPI.createHologram(Main.GetInstance(), loc.clone().add(0.5, 4.5, 0.5)); // Title
																									// Hologram

		hologram.appendTextLine(LanguageManager.GetText("altar.title"));
		hologram.appendTextLine(LanguageManager.GetFormattedText("altar.level", new RomanNumeral(itemArray.GetLevel()).toString())); 

		resultHolo = HologramsAPI.createHologram(Main.GetInstance(), loc.clone().add(0.5, 2, -itemArray.GetLevel() - 0.5));
	}

	public static AltarStructure CreateAltarStructure(Location loc, UUID owner)
	{
		ItemArrayCreatorBlockStructure itemArray = ItemArrayCreatorBlockStructure.Create(loc, owner, null);		
		if(itemArray == null) { return null; }
		
		AltarStructure res = new AltarStructure(loc, owner, itemArray);
		itemArray.SetCreationHandler(res);
		
		return res;
	}

	public static AltarStructure CreateAltarStructure(Location loc, UUID owner, int forcedLevel)
	{
		ItemArrayCreatorBlockStructure itemArray = ItemArrayCreatorBlockStructure.Create(loc, owner, forcedLevel, null);		
		if(itemArray == null) { return null; }
		
		AltarStructure res = new AltarStructure(loc, owner, itemArray);
		itemArray.SetCreationHandler(res);
		
		return res;
	}

	public static int GetAvailableAltarLevel(Location loc)
	{
		return ItemArrayCreatorBlockStructure.GetMaxLevel(loc);
	}

	public static int GetMaxAltarAmount(UUID uuid)
	{
		if (Bukkit.getPlayer(uuid) == null) { return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer(); }

		String val = Main.GetPermissionParameter(uuid, "magicAspect.crafting.create.altar");

		if (val == null || val
				.equalsIgnoreCase("default")) { return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer(); }

		try
		{
			int res = Integer.parseInt(val);

			return res > 0 ? res : Integer.MAX_VALUE;
		}
		catch (NumberFormatException ex)
		{
			Bukkit.getLogger().warning(
					"Corrupted max altar amount in permissions; permission: \"magicAspect.crafting.create.altar." + val
							+ "\"");
		}

		return Main.GetInstance().GetConfigManager().getMaxAltarsPerPlayer();
	}

	public static int GetMaxAltarLevel(UUID uuid)
	{
		if (Bukkit.getPlayer(uuid) == null) { return Main.GetInstance().GetConfigManager().getMaxAltarLevel(); }

		String val = Main.GetPermissionParameter(uuid, "magicAspect.crafting.create.altar.level");

		if (val == null
				|| val.equalsIgnoreCase("default")) { return Main.GetInstance().GetConfigManager().getMaxAltarLevel(); }

		try
		{
			int res = Integer.parseInt(val);

			return res > 0 ? res : Integer.MAX_VALUE;
		}
		catch (NumberFormatException ex)
		{
			Bukkit.getLogger()
					.warning(ChatColor.YELLOW
							+ "Corrupted max altar amount in permissions; permission: \"magicAspect.crafting.create.altar.level."
							+ val + "\"");
		}

		return Main.GetInstance().GetConfigManager().getMaxAltarLevel();
	}

	@Override
	public boolean Tick()
	{
		return itemArray.Tick();
	}

	@Override
	public void Dispose()
	{
		hologram.clearLines();
		hologram.delete();

		itemArray.Dispose();
	}

	@Override
	public boolean IsDisposed()
	{
		return (hologram == null || hologram.isDeleted()) && itemArray.IsDisposed();
	}

	@Override
	public int GetLevel()
	{
		return itemArray.GetLevel();
	}

	@Override
	public boolean HasOwner()
	{
		return itemArray.HasOwner();
	}

	@Override
	public UUID GetOwner()
	{
		return itemArray.GetOwner();
	}

	@Override
	public boolean Craft()
	{
		if (IsInProgress() || itemArray.IsEmpty()) { return false; }

		itemArray.BeginCreation();

		return true;
	}

	public boolean IsInProgress()
	{
		return itemArray.IsInProgress();
	}

	@Override
	public boolean DoesBelong(Location loc)
	{
		return this.itemArray.DoesBelong(loc);
	}

	@Override
	public boolean Click(Location loc, Player player, boolean isLeftClick)
	{
		if (!this.DoesBelong(loc)) { return false; }
		
		if (IsInProgress() || !player.hasPermission("magicAspect.crafting.bypassOwnership")
				&& Main.GetInstance().GetConfigManager().isAltarOwnershipChecking()
				&& !player.getUniqueId().equals(GetOwner())) { return true; }
		
		if (isLeftClick)
		{
			if (!Craft())
			{
				player.sendMessage(LanguageManager.GetText("altar.noItemsIn"));
			}

			return true;
		}

		return itemArray.Click(loc, player, false);
	}

	@Override
	public void onCreationHandle(ICreationInterface<ItemStack[][]> creationInterface)
	{
		Main.RunTaskAsync(new Runnable()
		{
			@Override
			public void run()
			{
				ItemStack[][] items = creationInterface.Return();
				
				ItemAltarRecipeInput input = new ItemAltarRecipeInput(GetOwner(), AltarStructure.this,
						items);

				final List<IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput>> recipes = Main
						.GetInstance().GetRecipeManager().GetMatchingRecipes(input);

				for (IRecipe<? super ItemAltarRecipeInput, ? extends ItemAltarRecipeOutput> recipe : recipes)
				{
					ItemAltarRecipeOutput recipeOutput = recipe.GetResult(input);

					if (recipeOutput == null)
					{
						continue;
					}

					Location dropLocation = altarloc.clone().add(0.5, 2, 0.5);

					Main.RunTask(new Runnable()
					{
						@Override
						public void run()
						{
							itemArray.SetArray(recipeOutput.itemsLeft);

							for (ItemStack result : recipeOutput.result)
							{
								while(result.getAmount() > result.getMaxStackSize())
								{
										ItemStack newRes = result.clone();
										newRes.setAmount(newRes.getMaxStackSize());
										result.setAmount(result.getAmount() - result.getMaxStackSize());
										
										altarloc.getWorld().dropItemNaturally(dropLocation, newRes);
								}
								
								altarloc.getWorld().dropItemNaturally(dropLocation, result);
							}
						}
					});
					
					return;
				}
			}
		});
	}

	@Override
	public void onErrorHandle(ICreationInterface<ItemStack[][]> creationInterface, int code)
	{
		// TODO Auto-generated method stub
		
	}
}
