package an0nym8us.bukkit.magicCrafting.altar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.Main;
import an0nym8us.bukkit.magicCrafting.NMSProvider;

public abstract class AltarRecipe implements Serializable, Cloneable, INameable, IItemAltarRecipe<ItemAltarRecipeInput, ItemAltarRecipeOutput>
{
	private static final long serialVersionUID = -4136701260214128569L;

	transient int id;
	transient boolean isIdSet = false;

	String recipeName;
	double recipePrice;

	protected AltarRecipe(String recipeName, double recipePrice)
	{
		this.recipeName = recipeName;
		this.recipePrice = recipePrice;
	}

	public final int MatchIS(ItemStack pattern, ItemStack ingredient, boolean checkOnlyType, boolean ignoreDurability)
	{
		if (!IsNull(pattern) && !IsNull(ingredient) && (pattern.getAmount() <= ingredient.getAmount())
				&& (checkOnlyType && pattern.getType().equals(ingredient.getType())
						&& (ignoreDurability || pattern.getDurability() == ingredient.getDurability()))
				|| (!checkOnlyType && pattern.isSimilar(ingredient) && pattern.getAmount() <= ingredient.getAmount()
						&& (ignoreDurability
								|| pattern.getDurability() == ingredient.getDurability()))) { return ingredient
										.getAmount() / pattern.getAmount(); }

		return IsNull(pattern) && IsNull(ingredient) ? Integer.MAX_VALUE : -1;
	}

	@SuppressWarnings("deprecation")
	public static final boolean IsNull(ItemStack is)
	{
		return is == null || is.getTypeId() == 0;
	}

	public static final boolean IsSerializable(AltarRecipe ar)
	{
		return ar instanceof Serializable;
	}
	
	public static ItemStack[] MergeIngredients(ItemStack[][] ar)
	{
		int counter = 0;		
		for(int i = 0; i < ar.length; i++)
		{
			for(int j = 0; j < ar[i].length; j++)
			{
				if(!IsNull(ar[i][j]))
				{
					counter++;
				}
			}
		}
		
		ItemStack[] res = new ItemStack[counter];
		
		counter = 0;
		for(int i = 0; i < ar.length; i++)
		{
			for(int j = 0; j < ar[i].length; j++)
			{
				if(!IsNull(ar[i][j]))
				{
					res[counter++] = ar[i][j].clone();
				}
			}
		}
		
		return res;
	}

	public static final ItemStack[] ClearIS(ItemStack[] ar)
	{
		for (int i = 0; i < ar.length; i++)
		{
			ItemStack is = ar[i];

			if (is != null && (is.equals(Material.AIR) || is.getAmount() < 1))
			{
				ar[i] = null;
			}
		}

		return ar;
	}

	public abstract MultiplyingMode GetMultiplyingMode();

	public boolean equals(Object obj)
	{
		if (obj != null && obj.getClass() == AltarRecipe.class && this.getClass() == AltarRecipe.class)
		{
			AltarRecipe ar = (AltarRecipe) obj;

			return this.recipeName.equals(ar.recipeName) && this.recipePrice == ar.recipePrice;
		}

		return false;
	}

	public int GetID()
	{
		return id;
	}

	public boolean HasID()
	{
		return isIdSet;
	}

	public void SetID(int id)
	{
		this.id = id;

		isIdSet = true;
	}

	public String GetName()
	{
		return recipeName;
	}

	public boolean HasName()
	{
		return recipeName != null;
	}

	@Override
	public boolean SetName(String recipeName)
	{
		this.recipeName = recipeName;

		return true;
	}

	public Double GetPrice()
	{
		return recipePrice;
	}

	public boolean HasPrice()
	{
		return recipePrice >= 0;
	}

	public void SetPrice(Double recipePrice)
	{
		this.recipePrice = recipePrice;
	}

	public abstract int GetRequiredAltarLevel();
	
	protected static Map<Character, Map<String, Object>> _SerializeISMap(Map<Character, ItemStack> map)
	{
		Map<Character, Map<String, Object>> res = new HashMap<Character, Map<String, Object>>();

		for (Entry<Character, ItemStack> en : map.entrySet())
		{
			res.put(en.getKey(), en.getValue() == null ? null : _SerializeIS(en.getValue()));
		}

		return res;
	}

	protected static Map<Character, ItemStack> _DeserializeISMap(Map<Character, Map<String, Object>> map)
	{
		Map<Character, ItemStack> res = new HashMap<Character, ItemStack>();

		for (Entry<Character, Map<String, Object>> en : map.entrySet())
		{
			res.put(en.getKey(), en.getValue() == null ? null : _DeserializeIS(en.getValue()));
		}

		return res;
	}

	protected static Map<String, Object> _SerializeIS(ItemStack is)
	{
		Map<String, Object> res = new HashMap<String, Object>();
		res.put("serializationVersion", 1);

		byte[] data = Serialize_v1(is);

		if (data == null) { return null; }

		res.put("serializedIS-NBT", data);

		return res;
	}

	protected static Map<String, Object>[] _SerializeISArray(ItemStack[] ar)
	{
		@SuppressWarnings("unchecked")
		Map<String, Object>[] res = new HashMap[ar.length];

		for (int i = 0; i < ar.length; i++)
		{
			res[i] = ar[i] == null ? null : _SerializeIS(ar[i]);
		}

		return res;
	}

	protected static ItemStack[] _DeserializeISArray(Map<String, Object>[] ar)
	{
		ItemStack[] res = new ItemStack[ar.length];

		for (int i = 0; i < ar.length; i++)
		{
			res[i] = ar[i] == null ? null : _DeserializeIS(ar[i]);
		}

		return res;
	}

	@SuppressWarnings("unchecked")
	protected static ItemStack _DeserializeIS(Map<String, Object> map)
	{
		int serializationVersion = 0;

		if (map.containsKey("serializationVersion"))
		{
			try
			{
				serializationVersion = (int) map.get("serializationVersion");
			}
			catch (ClassCastException ex)
			{
				Bukkit.getLogger().warning("Invalid serializationVersion type in serialized item");

				return null;
			}
		}

		try
		{
			switch (serializationVersion)
			{
				case 0:
				{
					if (map.containsKey("meta"))
					{
						map.put("meta",
								ConfigurationSerialization.deserializeObject((Map<String, Object>) map.get("meta"),
										ConfigurationSerialization.getClassByAlias("ItemMeta")));
					}

					return ItemStack.deserialize(map);
				}
				case 1:
				{
					if (!map.containsKey("serializedIS-NBT")) { throw new IllegalArgumentException(
							"Incomplete ItemStack datagram!"); }

					ItemStack res = Deserialize_v1((byte[]) map.get("serializedIS-NBT"));

					return res;
				}
				default:
					throw new IllegalArgumentException(
							"Recipe contains non-supported ItemStack datagram (interaction of third-party plugin?)!");
			}
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}

	protected static byte[] Serialize_v1(ItemStack is)
	{
		ByteArrayOutputStream baos = null;

		try
		{
			baos = new ByteArrayOutputStream();

			Class<?> _craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftItemStack");
			Class<?> _itemStack = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".ItemStack");
			Class<?> _nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagCompound");
			Class<?> _nbtCompressedStreamTools = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools");

			Object tag = _nbtTagCompound.newInstance();

			Method m0 = _itemStack.getDeclaredMethod("save", _nbtTagCompound);
			m0.setAccessible(true);
			Method m1 = _craftItemStack.getDeclaredMethod("asNMSCopy", ItemStack.class);
			m1.setAccessible(true);
			Method m2 = _nbtCompressedStreamTools.getDeclaredMethod("a", _nbtTagCompound, OutputStream.class);
			m2.setAccessible(true);

			tag = m0.invoke(m1.invoke(null, is), tag);

			m2.invoke(null, tag, baos);

			return baos.toByteArray();
		}
		catch (ClassNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InstantiationException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally
		{
			if (baos != null)
			{
				try
				{
					baos.close();
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
		}

		return null;
	}

	protected static ItemStack Deserialize_v1(byte[] data)
	{
		ByteArrayInputStream bais = null;

		try
		{
			bais = new ByteArrayInputStream(data);

			Class<?> _craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftItemStack");
			Class<?> _itemStack = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".ItemStack");
			Class<?> _nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagCompound");
			Class<?> _nbtCompressedStreamTools = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools");

			Method m0 = _nbtCompressedStreamTools.getDeclaredMethod("a", InputStream.class);
			m0.setAccessible(true);
			Method m1 = _craftItemStack.getDeclaredMethod("asBukkitCopy", _itemStack);
			m1.setAccessible(true);
			Method m2 = _itemStack.getDeclaredMethod("createStack", _nbtTagCompound);
			m2.setAccessible(true);

			Object tag = m0.invoke(null, bais);

			return (ItemStack) m1.invoke(null, m2.invoke(null, tag));
		}
		catch (ClassCastException ex)
		{
			Bukkit.getLogger().warning("Invalid serializedIS-NBT type in serialized item");

			return null;
		}
		catch (ClassNotFoundException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (NoSuchMethodException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally
		{
			if (bais != null)
			{
				try
				{
					bais.close();
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
		}

		return null;
	}
}
