
package an0nym8us.bukkit.magicCrafting.altar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.warmonger.Program;
import an0nym8us.warmonger.ProgramExecutionFailureException;

public class AdvancedShapelessAltarRecipe extends AdvancedAltarRecipe
{
	private static final long serialVersionUID = 1L;
	
	RecipeItemStack[] ingredients;
	RecipeItemStack[] result;

	public AdvancedShapelessAltarRecipe(String name, Program matchingProgram, Program preProgram, Program postProgram, RecipeItemStack[] ingredients, RecipeItemStack... result)
	{
		super(name, matchingProgram, preProgram, postProgram);

		this.ingredients = ingredients;
		this.result = result;
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		return (int) Math.ceil(Math.sqrt(ingredients.length));
	}
	
	@Override
	public RecipeItemStack[] GetTemplateIngredients()
	{
		return ingredients;
	}

	@Override
	public RecipeItemStack[] GetTemplateResults()
	{
		return result;
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params)
	{
		Object[] ingr = ((Object[])params.get(INGREDIENTS_CODE));
		
		if (ingr.length < this.ingredients.length || !ExecuteMatchingProgram(params)) { return false; }
		
		outerloop: for (int i = 0; i < this.ingredients.length && i < ingr.length; i++)
		{
			for (int j = i; j < this.ingredients.length && j < ingr.length; j++)
			{
				if(this.ingredients[i].DoesMatch(ingr[j], params))
				{
					Object swapArea = ingr[i];
					ingr[i] = ingr[j];
					ingr[j] = swapArea;
					
					continue outerloop;
				}
			}
			
			return false;
		}
		
		return true;
	}

	@Override
	public Map<String, Object> GetResult(Map<String, Object> params)
	{
		switch (multiplyingMode)
		{
			case NONE:
			{
				if (!DoesMatch(params))
				{
					throw new IllegalArgumentException("Given items do NOT match given recipe.");
				}

				if (preProgram.Execute(params).GetValue(params) != Program.SUCCESS_CODE)
				{
					throw new ProgramExecutionFailureException(preProgram, "preProgram");
				}
				
				if(!ExecuteStep(params))
				{
					throw new IllegalStateException("Could not execute through item templates.");
				}

				if (postProgram.Execute(params).GetValue(params) == Program.SUCCESS_CODE)
				{
					params.put(AdvancedAltarRecipe.RESULT_CODE, RecipeItemStack.GenerateISArray(this.result, params));
					
					return params;
				}
				
				throw new ProgramExecutionFailureException(postProgram, "postProgram");
			}
			case CASCADE:
			{
				List<ItemStack> result = new ArrayList<ItemStack>();

				while (DoesMatch(params))
				{
					if (preProgram.Execute(params).GetValue(params) != Program.SUCCESS_CODE)
					{
						throw new ProgramExecutionFailureException(preProgram, "preProgram");
					}
					
					if(!ExecuteStep(params))
					{
						throw new IllegalStateException("Could not execute through item templates.");
					}

					if (postProgram.Execute(params).GetValue(params) != Program.SUCCESS_CODE)
					{
						throw new ProgramExecutionFailureException(postProgram, "postProgram");
					}
					
					for (RecipeItemStack ris : this.result)
					{
						result.add(ris.GenerateIS(params));
					}
				}
				
				params.put(AdvancedAltarRecipe.RESULT_CODE, result.toArray(new ItemStack[result.size()]));

				return params;
			}
			case STACKED:
			{
				throw new UnsupportedOperationException("STACKED mode is not supported yet!");
			}
			default:
				throw new IllegalArgumentException("Invalid MultiplyingMode state!");
		}
	}
	
	public boolean ExecuteStep(Map<String, Object> params)
	{
		Object[] originalIngr = ((Object[])params.get(INGREDIENTS_CODE));
		Object[] ingr = originalIngr.clone();
		RecipeItemStack[] rIngr = ingredients.clone();
		
		if (ingr.length < this.ingredients.length) { return false; }
		
		outerloop: for (int i = 0; i < ingr.length; i++)
		{
			for (int j = 0; j < rIngr.length; j++)
			{
				if(rIngr[j] != null && ingr[i] != null && rIngr[j].DoesMatch(ingr[i], params))
				{					
					if(rIngr[j].HasProgram())
					{
						if(rIngr[j].GetProgram().Execute(params).GetValue(params) != Program.SUCCESS_CODE)
						{
							return false;
						}
					}
					else
					{
						int amount = (int) rIngr[j].GetStructure().GetNBTValue("item.Count").GetValue(params);
						
						ItemStack is = ISBuilder.DeserializeIS(originalIngr[i]);
						is.setAmount(is.getAmount() > amount ? is.getAmount() - amount : 0);
						originalIngr[i] = ISBuilder.SerializeIS(is);
					}
					
					ingr[i] = null;
					rIngr[j] = null;
					
					continue outerloop;
				}
			}
			
			return false;
		}
		
		params.put(INGREDIENTS_CODE, originalIngr);
		
		return true;
	}
}
