package an0nym8us.bukkit.magicCrafting.altar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.warmonger.Program;
import an0nym8us.warmonger.ProgramExecutionFailureException;

public class AdvancedShapedAltarRecipe extends AdvancedAltarRecipe
{
	private static final long serialVersionUID = 1L;

	Map<Integer, RecipeItemStack> ingredientMap;
	char[][] ingredientMatrix;

	RecipeItemStack[] result;

	public AdvancedShapedAltarRecipe(String name, Program matchingProgram, Program preProgram, Program postProgram,
			Map<Integer, RecipeItemStack> ingredientMap, char[][] ingredientMatrix, RecipeItemStack[] result)
	{
		super(name, matchingProgram, preProgram, postProgram);

		this.ingredientMap = ingredientMap;
		this.ingredientMatrix = ingredientMatrix;
		this.result = result;
	}

	@Override
	public int GetRequiredAltarLevel()
	{
		int lvl = ingredientMatrix.length;

		for (int i = 0; i < ingredientMatrix.length; i++)
		{
			if (lvl > ingredientMatrix[i].length)
			{
				lvl = ingredientMatrix[i].length;
			}
		}

		return lvl;
	}

	/*
	 * @Override public boolean DoesMatch(Map<String, Object> params) // Given
	 * // item // array // must // be // a // square // of // natural // number
	 * // higher // than // 0! // Otherwise // result // will // be //
	 * uncertain. { int a = (int) Math.sqrt(ar.length);
	 * 
	 * if (a > GetRequiredAltarLevel() || !ExecuteMatchingProgram(params)) {
	 * return false; }
	 * 
	 * int beginIndex = -1;
	 * 
	 * for (int i = 0; i < ar.length; i++) { if (!IsNull(ar[i])) { beginIndex =
	 * -1; } }
	 * 
	 * if (beginIndex < 0) { return false; }
	 * 
	 * for (int i = 0; i < ingredientMatrix.length; i++) { for (int j = 0; j <
	 * ingredientMatrix[i].length; j++) { if
	 * (!ingredientMap.get(ingredientMatrix[i][j]).DoesMatch(ar[beginIndex + j +
	 * i * a], params)) { return false; } } }
	 * 
	 * return true; }
	 */

	@Override
	public boolean DoesMatch(Map<String, Object> params) // Given
															// item
															// array
															// must
															// be
															// a
															// square
															// of
															// natural
															// number
															// higher
															// than
															// 0!
															// Otherwise
															// result
															// will
															// be
															// uncertain.
	{
		Object[] ar = (Object[]) params.get(INGREDIENTS_CODE);

		int a = (int) Math.sqrt(ar.length);

		if (a > GetRequiredAltarLevel() || !ExecuteMatchingProgram(params)) { return false; }

		int beginIndex = -1;

		for (int i = 0; i < ar.length; i++)
		{
			if (ar[i] != null) // FIXME this
			{
				beginIndex = i;

				break;
			}
		}

		if (beginIndex < 0) { return false; }

		for (int i = 0; i < ingredientMatrix.length; i++)
		{
			for (int j = 0; j < ingredientMatrix[i].length; j++)
			{
				RecipeItemStack ris = ingredientMap.get(ingredientMatrix[i][j]);

				if (ris == null)
				{
					if (ar[beginIndex + j + i * a] != null) { return false; }
				}
				else
				{
					if (!ingredientMap.get(ingredientMatrix[i][j]).DoesMatch(ar[beginIndex + j + i * a],
							params)) { return false; }
				}
			}
		}

		return true;
	}

	public Map<String, Object> GetResult(Map<String, Object> params)
	{
		// params.put(AdvancedAltarRecipe.INGREDIENTS_CODE,
		// ISBuilder.SerializeIS(items));

		switch (multiplyingMode)
		{
			case NONE:
			{
				if (!DoesMatch(
						params)) { throw new IllegalArgumentException("Given items do NOT match given recipe."); }

				ItemStack[] res = new ItemStack[result.length];

				if (preProgram.Execute(params).GetValue(
						params) != Program.SUCCESS_CODE) { throw new ProgramExecutionFailureException(preProgram,
								"preProgram"); }

				ExecuteStep(params);

				if (postProgram.Execute(params).GetValue(params) == Program.SUCCESS_CODE)
				{
					params.put(AdvancedAltarRecipe.RESULT_CODE, RecipeItemStack.GenerateISArray(this.result, params));

					return params;
				}

				throw new ProgramExecutionFailureException(postProgram, "postProgram");
			}
			case CASCADE:
			{
				List<ItemStack> result = new ArrayList<ItemStack>();

				while (DoesMatch(params))
				{
					if (preProgram.Execute(params).GetValue(params) != Program.SUCCESS_CODE)
					{
						throw new ProgramExecutionFailureException(preProgram, "preProgram");
					}
					
					if(!ExecuteStep(params))
					{
						throw new IllegalStateException("Could not execute through item templates.");
					}

					if (postProgram.Execute(params).GetValue(params) != Program.SUCCESS_CODE)
					{
						throw new ProgramExecutionFailureException(postProgram, "postProgram");
					}
					
					for (RecipeItemStack ris : this.result)
					{
						result.add(ris.GenerateIS(params));
					}
				}

				params.put(AdvancedAltarRecipe.RESULT_CODE, result.toArray(new ItemStack[result.size()]));

				return params;
			}
			case STACKED:
			{
				throw new UnsupportedOperationException("STACKED mode is not supported yet!");
			}
			default:
				throw new IllegalArgumentException("Invalid MultiplyingMode state!");
		}
	}

	public boolean ExecuteStep(Map<String, Object> params)
	{
		Object[] ar = (Object[]) params.get(INGREDIENTS_CODE);

		int a = (int) Math.sqrt(ar.length);

		if (a > GetRequiredAltarLevel() || !ExecuteMatchingProgram(params)) { return false; }

		int beginIndex = -1;

		for (int i = 0; i < ar.length; i++)
		{
			if (ar[i] != null) // FIXME this
			{
				beginIndex = i;

				break;
			}
		}

		if (beginIndex < 0) { return false; }

		for (int i = 0; i < ingredientMatrix.length; i++)
		{
			for (int j = 0; j < ingredientMatrix[i].length; j++)
			{
				RecipeItemStack ris = ingredientMap.get(ingredientMatrix[i][j]);

				if (ris == null)
				{
					if (ar[beginIndex + j + i * a] != null) { return false; }
				}
				else
				{
					if (ris.DoesMatch(ar[beginIndex + j + i * a], params))
					{
						if (ris.HasProgram())
						{
							if (ris.GetProgram().Execute(params)
									.GetValue(params) != Program.SUCCESS_CODE) { return false; }
						}
						else
						{
							int amount = (int) ris.GetStructure().GetNBTValue("item.Count").GetValue(params);

							ItemStack is = ISBuilder.DeserializeIS(ar[beginIndex + j + i * a]);
							is.setAmount(is.getAmount() > amount ? is.getAmount() - amount : 0);
							ar[beginIndex + j + i * a] = ISBuilder.SerializeIS(is);
						}
					}
					else
					{
						return false;
					}
				}
			}
		}

		return true;
	}

	@Override
	public RecipeItemStack[] GetTemplateIngredients()
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RecipeItemStack[] GetTemplateResults()
	{
		// TODO Auto-generated method stub
		return null;
	}
}
