package an0nym8us.bukkit.magicCrafting.altar;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.bukkit.inventory.ItemStack;

import an0nym8us.bukkit.magicCrafting.ISBuilder;
import an0nym8us.warmonger.Program;

public abstract class AdvancedAltarRecipe implements IWarmongerAltarRecipe, INameable, ILevelable
{
	private static final long serialVersionUID = 1L;
int ifds;
	public static final String INGREDIENTS_CODE = "recipe.ingredients";
	public static final String TEMPLATE_INGREDIENTS_CODE = "recipe.templateIngredients";
	public static final String RESULT_CODE = "recipe.result";
	public static final String TEMPLATE_RESULTS_CODE = "recipe.templateResult";
	public static final String PLAYER_EXECUTOR_CODE = "recipe.playerExecutor";
	public static final String PLAYER_OWNER_CODE = "recipe.playerOwner";
	public static final String PRICE_CODE = "recipe.price";
	public static final String STRUCT_X_CODE = "recipe.structX";
	public static final String STRUCT_Y_CODE = "recipe.structY";
	public static final String STRUCT_Z_CODE = "recipe.structZ";
	public static final String STRUCT_WORLD_CODE = "recipe.structWorld";
	public static final String STRUCT_CODE = "recipe.struct";

	String recipeName;

	Program matchingProgram;
	Program preProgram;
	Program postProgram;

	MultiplyingMode multiplyingMode;

	public AdvancedAltarRecipe(Program matchingProgram, Program preProgram, Program postProgram)
	{
		this(null, matchingProgram, preProgram, postProgram);
	}

	public AdvancedAltarRecipe(String recipeName, Program matchingProgram, Program preProgram, Program postProgram)
	{
		this.recipeName = recipeName;
		this.matchingProgram = matchingProgram;
		this.postProgram = postProgram;
	}

	@Override
	public boolean HasName()
	{
		return recipeName != null;
	}

	@Override
	public String GetName()
	{
		return recipeName;
	}

	@Override
	public boolean SetName(String recipeName)
	{
		this.recipeName = recipeName;

		return true;
	}

	public static Map<String, Object> PrepareMatchingParams(ItemStack[] ingredients, UUID executor, UUID owner,
			IAltarStructure struct)
	{
		Map<String, Object> params = new HashMap<String, Object>();

		params.put(INGREDIENTS_CODE, ISBuilder.SerializeIS(ingredients)); // Object[]
																			// ->
																			// serialized
																			// ItemStacks
																			// //
																			// Object
																			// ->
																			// serialized
																			// ItemStack
		params.put(PLAYER_EXECUTOR_CODE, executor); // UUID
		params.put(PLAYER_OWNER_CODE, owner); // UUID
		params.put(STRUCT_CODE, struct); // IAltarStructure // Location

		return params;
	}

	public static Map<String, Object> PrepareParams(RecipeItemStack[] templateIngredients, ItemStack[] ingredients,
			RecipeItemStack[] templateResult, UUID executor, UUID owner, double price, IAltarStructure struct)
	{
		Map<String, Object> params = new HashMap<String, Object>();

		params.put(TEMPLATE_INGREDIENTS_CODE, RecipeItemStack.Convert(templateIngredients));// NBTAbstractValue<?>[]
		params.put(TEMPLATE_RESULTS_CODE, RecipeItemStack.Convert(templateResult)); // NBTAbstractValue
		params.put(INGREDIENTS_CODE, ISBuilder.SerializeIS(ingredients)); // Object[]
																			// ->
																			// serialized
																			// ItemStacks
		// params.put(RESULT_CODE, ISBuilder.SerializeIS(result)); // Object ->
		// serialized ItemStack
		params.put(PLAYER_EXECUTOR_CODE, executor); // UUID
		params.put(PLAYER_OWNER_CODE, owner); // UUID
		params.put(STRUCT_CODE, struct); // IAltarStructure

		return params;
	}

	/*
	 * public static Program PrepareMatchingProgram() { LocalVariable<Integer>
	 * var0 = new LocalVariable<Integer>("i"); Variable<Object[]> ar = new
	 * LocalVariable(INGREDIENTS_CODE); MathFunction<LocalVariable<Integer>> inc
	 * = new MathFunction<LocalVariable<Integer>>(var0,
	 * MathActionType.Increment);
	 * 
	 * LoopFunction loop = new LoopFunction(new ComparisionFunction(new
	 * NumberVariable(new Constant<Integer>(0), new Constant<Integer>(10)),
	 * var0), new ComparisionFunction(new NBTVariable(new
	 * GetElementFunction())), inc);
	 * 
	 * return new Program(loop); }
	 */

	public boolean ExecuteMatchingProgram(Map<String, Object> params)
	{
		return matchingProgram.Execute(params).GetValue(params) == Program.SUCCESS_CODE;
	}

	public boolean ExecutePreProgram(Map<String, Object> params)
	{
		return preProgram.Execute(params).GetValue(params) == Program.SUCCESS_CODE;
	}

	public boolean ExecutePostProgram(Map<String, Object> params)
	{
		return postProgram.Execute(params).GetValue(params) == Program.SUCCESS_CODE;
	}

	public MultiplyingMode GetMultiplyingMode()
	{
		return multiplyingMode;
	}

	public abstract RecipeItemStack[] GetTemplateIngredients();

	public abstract RecipeItemStack[] GetTemplateResults();

	// public abstract int GetRequiredAltarLevel();

	// public abstract boolean DoesMatch(ItemStack[] ingredients, Map<String,
	// Object> params);

	// public abstract boolean DoesMatch(Object[] ingredients, Map<String,
	// Object> params);

	/*
	 * public boolean ExecuteRecipe(IAltarStructure altarStructure, UUID
	 * executor) { Map<String, Object> params =
	 * PrepareParams(GetTemplateIngredients(), altarStructure.GetItemArray(),
	 * GetTemplateResults(), altarStructure.GetOwner(), executor,
	 * this.recipePrice, altarStructure);
	 * 
	 * //for() }
	 */

	/*
	 * @Override public final boolean DoesMatch(ItemStack[] ar) { throw new
	 * UnsupportedOperationException(); }
	 * 
	 * @Override public final ItemStack GetResult(ItemStack[] items) { throw new
	 * UnsupportedOperationException(); }
	 */

	public final ItemStack[] GetItemsLeft(ItemStack[] input, Map<String, Object> params)
	{
		return ISBuilder.DeserializeIS((Object[]) params.get(INGREDIENTS_CODE));
	}
}
