package an0nym8us.bukkit.magicCrafting;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

import an0nym8us.bukkit.magicCrafting.altar.AltarRecipe;
import net.milkbowl.vault.economy.Economy;

public class VaultService
{
	private Economy economy = null;

	public VaultService()
	{
		SetupEconomy();
	}

	public boolean IsEnabled()
	{
		return economy != null;
	}

	private boolean SetupEconomy()
	{
		if (!Main.GetInstance().GetConfigManager().isEnableVaultService() || Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) { return false; }

		RegisteredServiceProvider<Economy> rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);

		if (rsp == null) { return false; }

		economy = rsp.getProvider();
		return economy != null;
	}
	
	public int GetMaxRecipes(UUID uuid, AltarRecipe ar)
	{
		if (!IsEnabled()) { return Integer.MAX_VALUE; }

		OfflinePlayer player = Bukkit.getOfflinePlayer(uuid);

		if (player == null || !ar.HasPrice()) { return Integer.MAX_VALUE; }
		
		double bal = economy.getBalance(Bukkit.getOfflinePlayer(uuid));
		
		return bal > 0 ? (int) (bal / ar.GetPrice()) : 0;
	}

	public double GetBalance(UUID uuid)
	{
		if (!IsEnabled()) { return -1; }

		OfflinePlayer player = Bukkit.getOfflinePlayer(uuid);

		if (player == null) { return -1; }

		return economy.getBalance(Bukkit.getOfflinePlayer(uuid));
	}

	public boolean Pay(UUID uuid, double amount)
	{
		if (!IsEnabled()) { return true; }

		OfflinePlayer player = Bukkit.getOfflinePlayer(uuid);

		if (player == null) { return false; }

		if (economy.getBalance(Bukkit.getOfflinePlayer(uuid)) >= amount)
		{
			return economy.withdrawPlayer(player, amount).transactionSuccess();
		}

		return false;
	}
}
