package an0nym8us.bukkit.magicCrafting;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class SerializationInputStream extends ObjectInputStream
{
	public SerializationInputStream(InputStream in) throws IOException
	{
		super(in);
	}

	protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException
	{
		ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
		
		Class<?> localClass;
		
		try
		{
			localClass = Class.forName(resultClassDescriptor.getName());
		}
		catch (ClassNotFoundException e)
		{
			return resultClassDescriptor;
		}
		
		ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
		
		if (localClassDescriptor != null)
		{
			final long localSUID = localClassDescriptor.getSerialVersionUID();
			final long streamSUID = resultClassDescriptor.getSerialVersionUID();
			
			if (streamSUID != localSUID && streamSUID == -9065326695815294690L)
			{
				resultClassDescriptor = localClassDescriptor;
			}
		}
		
		return resultClassDescriptor;
	}
}
