package an0nym8us.bukkit.magicCrafting;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import org.bukkit.Bukkit;

public class NMSProvider
{
	private static Map<String, Class<?>> map;
	private static Map<Class<?>, Map<String, Method>> methods;
	private static String nmsVersion;

	static
	{
		map = new HashMap<String, Class<?>>();
		methods = new HashMap<Class<?>, Map<String, Method>>();

		nmsVersion = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit.", "");
	}

	public static Class<?> GetClass(String className) throws ClassNotFoundException
	{
		Class<?> res = map.get(className);

		if (res == null)
		{
			res = Class.forName(className);

			map.put(className, res);
		}

		return res;
	}
	
	public static Method GetMethod(Class<?> clazz, String method, Class<?>... params) throws NoSuchMethodException, SecurityException
	{
		return clazz.getDeclaredMethod(method, params);
		
		/*Map<String, Method> res = methods.get(clazz);
		
		if(res == null)
		{
			res =  new HashMap<String, Method>();
			
			Method m = clazz.getDeclaredMethod(method, params);
			
			res.put(method, m);
			methods.put(clazz;
		}*/
	}

	public static String GetNMSVersion()
	{
		return nmsVersion;
	}
}
