package an0nym8us.bukkit.magicCrafting;

import java.util.Iterator;

public class MultiIterator<T> implements Iterator<T>
{
	Iterator<T>[] iterators;
	int currentIterator;
	
	public MultiIterator(Iterator<T>[] iterators)
	{
		this.iterators = iterators;
		
		currentIterator = 0;
	}
	
	@Override
	public boolean hasNext()
	{
		return currentIterator + 1 < iterators.length || (currentIterator < iterators.length && iterators[currentIterator].hasNext());
	}

	@Override
	public T next()
	{
		if(!iterators[currentIterator].hasNext())
		{
			currentIterator++;
			
			return next();
		}
		
		return iterators[currentIterator].next();
	}
}
