package an0nym8us.bukkit.magicCrafting;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;

import an0nym8us.bukkit.magicCrafting.altar.IStructure;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeInput;
import an0nym8us.bukkit.magicCrafting.altar.ItemAltarRecipeOutput;
import an0nym8us.bukkit.magicCrafting.altar.recipeCreation.DeprecatedRecipeCreationMenu;
import an0nym8us.bukkit.magicCrafting.brewing.BrewingManager;
import an0nym8us.bukkit.magicCrafting.listener.BrewingListener;
import an0nym8us.bukkit.magicCrafting.listener.MainListener;
import an0nym8us.bukkit.magicCrafting.listener.StructureListener;
import an0nym8us.bukkit.magicCrafting.listener.TextCreationListener;
import an0nym8us.bukkit.magicCrafting.managers.ConfigManager;
import an0nym8us.bukkit.magicCrafting.managers.FileRecipeManager;
import an0nym8us.bukkit.magicCrafting.managers.IIDRecipeManager;
import an0nym8us.bukkit.magicCrafting.managers.IRecipeManager;
import an0nym8us.bukkit.magicCrafting.managers.LanguageManager;
import an0nym8us.bukkit.magicCrafting.managers.PreloadedRecipeManager;
import an0nym8us.bukkit.magicCrafting.managers.StructureManager;
import an0nym8us.bukkit.magicCrafting.managers.TestRecipeManager;
import an0nym8us.bukkit.magicCrafting.menu.AdminMenu;
import an0nym8us.bukkit.magicCrafting.menu.CreationMenu;
import an0nym8us.bukkit.magicCrafting.menu.CreationMenu.CreationMenuSession;
import an0nym8us.cyanide.CreationChoiceMenu;
import an0nym8us.cyanide.CreationChoiceMenu.CreationChoiceMenuSession;
import an0nym8us.cyanide.CreationModule;
import an0nym8us.cyanide.ICreationHandler;
import an0nym8us.cyanide.ICreationInterface;
import an0nym8us.processorSession.SiteSession;
import an0nym8us.utils.menu.InventorySessionListener;
import an0nym8us.utils.menu.InventorySessionManager;
import an0nym8us.utils.menu.SiteMenuInventorySession;

public class Main extends JavaPlugin
{
	public static class Test
	{
		int a;
		String s;
		
		public Test(int a, String s)
		{
			this.a = a;
			this.s = s;
		}
	}
	private static Main instance = null;

	private ConfigManager configManager;
	private BrewingManager brewingManager;
	private IIDRecipeManager<Integer, ItemAltarRecipeInput, ItemAltarRecipeOutput> recipeManager;
	private StructureManager structureManager;
	private LanguageManager languageManager;
	private InventorySessionManager inventorySessionManager;
	
	private MainListener mainListener;
	private StructureListener altarListener;
	private BrewingListener brewingListener;
	private TextCreationListener creationTextListener;
	private InventorySessionListener inventorySessionListener;

	private DeprecatedRecipeCreationMenu drcM;
	private AdminMenu adminMenu;

	private VaultService vaultService = null;

	public Main()
	{
		if (instance != null) { throw new IllegalStateException("Object has already been instantiated!"); }

		Main.instance = this;
		
		CompatibilityProvider.Initialize();
	}

	public static Main GetInstance()
	{
		return instance;
	}

	public static String GetNmsVersion()
	{
		return NMSProvider.GetNMSVersion();
	}

	public static BukkitTask RunTask(Runnable r)
	{
		return Bukkit.getScheduler().runTask(Main.GetInstance(), r);
	}

	public static final BukkitTask RunTaskAsync(Runnable r)
	{
		return Bukkit.getScheduler().runTaskAsynchronously(Main.GetInstance(), r);
	}

	@Override
	public void onEnable()
	{
		configManager = new ConfigManager();
		brewingManager = new BrewingManager(configManager.isEnableBrewingCauldron());

		structureManager = new StructureManager();
		languageManager = new LanguageManager();
		inventorySessionManager = new InventorySessionManager();
		
		recipeManager = new TestRecipeManager(true);
		
		/*if (configManager.isMysqlEnabled())
		{
			try
			{
				recipeManager = new SQLRecipeManager(configManager.isPreloadMinecraftRecipes(), this,
						configManager.getMysqlHostname(), configManager.getMysqlPort(),
						configManager.getMysqlDatabase(), configManager.getMysqlUserName(),
						configManager.getMysqlPassword());
			}
			catch (SQLException e)
			{
				Bukkit.getLogger().warning(
						"Cannot connect to database. Using file storage at this moment. Check your config and/or database server");

				e.printStackTrace();

				recipeManager = new FileRecipeManager(configManager.isPreloadMinecraftRecipes());
			}
		}
		else
		{
			recipeManager = new FileRecipeManager(configManager.isPreloadMinecraftRecipes());
		}*/

		if (recipeManager instanceof PreloadedRecipeManager)
		{
			((PreloadedRecipeManager) recipeManager).LoadRecipes();
		}
		
		mainListener = new MainListener();
		altarListener = new StructureListener();
		brewingListener = new BrewingListener();
		creationTextListener = new TextCreationListener();
		inventorySessionListener = new InventorySessionListener(inventorySessionManager);

		//drcM = new DeprecatedRecipeCreationMenu();
		adminMenu = new AdminMenu();

		vaultService = new VaultService();

		Bukkit.getPluginManager().registerEvents(mainListener, this);
		Bukkit.getPluginManager().registerEvents(altarListener, this);
		Bukkit.getPluginManager().registerEvents(inventorySessionListener, this);

		if (configManager.isEnableBrewingCauldron())
		{
			Bukkit.getPluginManager().registerEvents(brewingListener, this);
		}
		
		Bukkit.getPluginManager().registerEvents(creationTextListener, this);

		ProtocolLibrary.getProtocolManager().addPacketListener(altarListener);

		Bukkit.getLogger().info("MagicCrafting enabled!");
	}

	@Override
	public void onDisable()
	{
		if (brewingManager != null)
		{
			brewingManager.Dispose();
		}
		
		if(structureManager != null)
		{
			structureManager.Dispose();
		}

		if (inventorySessionManager != null)
		{
			inventorySessionManager.Dispose();
		}

		if (adminMenu != null)
		{
			//adminMenuDispose();.
		}

		if (recipeManager != null)
		{
			recipeManager.Dispose();
		}

		Bukkit.getLogger().info("MagicCrafting disabled!");
	}

	public static String GetPermissionParameter(UUID uuid, String permission)
	{
		Set<PermissionAttachmentInfo> permissions = Bukkit.getPlayer(uuid).getEffectivePermissions();

		for (PermissionAttachmentInfo pai : permissions)
		{
			if (pai.getPermission().startsWith(permission.toLowerCase() + "."))
			{
				String param = pai.getPermission().substring(permission.length() + 1, pai.getPermission().length());

				if (param.equals("~"))
				{
					return null;
				}
				else if (param.contains("."))
				{
					continue;
				}
				else
				{
					if (pai.getValue()) { return param; }

					break;
				}
			}
		}

		return null;
	}

	public ConfigManager GetConfigManager()
	{
		return configManager;
	}

	public BrewingManager GetBrewingManager()
	{
		return brewingManager;
	}

	public IIDRecipeManager<Integer, ItemAltarRecipeInput, ItemAltarRecipeOutput> GetRecipeManager()
	{
		return recipeManager;
	}

	public StructureManager GetStructureManager()
	{
		return structureManager;
	}

	public LanguageManager GetLanguageManager()
	{
		return languageManager;
	}
	
	public InventorySessionManager GetSessionManager()
	{
		return inventorySessionManager;
	}

	public TextCreationListener GetTextCreationListener()
	{
		return creationTextListener;
	}

	public VaultService GetVaultService()
	{
		return vaultService;
	}

	public AdminMenu GetAdminMenu()
	{
		return adminMenu;
	}

	public DeprecatedRecipeCreationMenu GetDeprecatedRecipeCreationMenu()
	{
		return drcM;
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String name, String[] args)
	{
		if (cmd.getName().equalsIgnoreCase("magicCrafting") || cmd.getName().equalsIgnoreCase("mc"))
		{
			if (args[0].equals("drcm"))
			{
				CreationChoiceMenu nccm = new CreationChoiceMenu();
				
				ICreationHandler<Class<? extends ICreationInterface<Object>>> h = new ICreationHandler<Class<? extends ICreationInterface<Object>>>()
				{
					@Override
					public void onCreationHandle(
							ICreationInterface<Class<? extends ICreationInterface<Object>>> creationInterface)
					{
						Bukkit.getLogger().info("IT IS DONE!");
						Bukkit.getLogger().info(creationInterface.Return().toString());
					}

					@Override
					public void onErrorHandle(
							ICreationInterface<Class<? extends ICreationInterface<Object>>> creationInterface, int code)
					{
						// TODO Auto-generated method stub
						
					}
				};
				
				CreationChoiceMenuSession<Object> nccms = new CreationChoiceMenuSession(((Player)sender).getUniqueId(), inventorySessionManager, nccm, h, Number.class);
				inventorySessionManager.InsertSession(nccms);
				
				
				nccms.Update();
				nccms.Open();
				/*DeprecatedRecipeCreationMenuSession dcmS = new DeprecatedRecipeCreationMenuSession(((Player)sender).getUniqueId(), drcM);
				
				inventorySessionManager.InsertSession(dcmS);
				
				dcmS.Open();*/
				
				return true;
			}
			else if (args[0].equals("reqs"))
			{				
				//CreationMenu.CreationMenuSession<?> ccss = new CreationMenu.CreationMenuSession(new CreationInterfaceFactoryData(((Player)sender).getUniqueId(), null, Object.class));
				ICreationHandler<TestObj> h = new ICreationHandler<TestObj>()
				{
					@Override
					public void onCreationHandle(
							ICreationInterface<TestObj> creationInterface)
					{
						Bukkit.getLogger().info("IT IS DONE!");
						Bukkit.getLogger().info(creationInterface.Return().t1);
					}

					@Override
					public void onErrorHandle(ICreationInterface<TestObj> creationInterface, int code)
					{
						Bukkit.getLogger().info("It is error :(");
					}
				};
				
				CreationModule.Create(((Player)sender).getUniqueId(), TestObj.class, h).BeginCreation();

				return true;
			}
			else if (args.length == 0 || args[0].equalsIgnoreCase("help"))
			{
				sender.sendMessage(ChatColor.GOLD + "MagicCrafting v" + this.getDescription().getVersion()
						+ " by An0nym8us - invocation to MagicAspect!");
				sender.sendMessage(LanguageManager.GetText("help.line0"));

				if (sender instanceof Player)
				{
					String text = LanguageManager.GetText("help.clickMe");
					String url = "https://www.spigotmc.org/resources/magiccrafting.24000/";

					PacketContainer pc = new PacketContainer(PacketType.Play.Server.CHAT);
					pc.getModifier().writeDefaults();
					pc.getChatComponents().write(0,
							WrappedChatComponent.fromJson("{\"text\":\"" + text
									+ "\",\"bold\":true,\"color\":\"red\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\""
									+ url + "\"}}"));

					try
					{
						ProtocolLibrary.getProtocolManager().sendServerPacket((Player) sender, pc);
					}
					catch (InvocationTargetException e)
					{
						e.printStackTrace();
					}
				}

				sender.sendMessage(LanguageManager.GetFormattedText("help.line1", "Commands:"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line2", "/magicCrafting"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line3", "/magicCrafting help"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line4", "/magicCrafting admin"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line5", "/magicCrafting admin disposeAll"));
				sender.sendMessage(
						LanguageManager.GetFormattedText("help.line6", "/magicCrafting admin disposeAltars"));
				sender.sendMessage(
						LanguageManager.GetFormattedText("help.line7", "/magicCrafting admin disposeCauldrons"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line8", "/magicCrafting creator"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line9", "/magicCrafting destroy"));
				sender.sendMessage(
						LanguageManager.GetFormattedText("help.line10", "/magicCrafting admin deleteRecipe <ID>"));
				sender.sendMessage(LanguageManager.GetFormattedText("help.line11", "/magicCrafting admin save"));

				return true;
			}

			if (args[0].equalsIgnoreCase("admin"))
			{
				if (!sender.hasPermission("magicAspect.crafting.admin") && args.length > 1)
				{
					sender.sendMessage(LanguageManager.GetText("noPermission"));

					return true;
				}
				else if (args.length > 1)
				{
					if (args[1].equalsIgnoreCase("disposeAll"))
					{
						GetStructureManager().DisposeStructures();
						GetBrewingManager().DisposeStructures();

						Bukkit.broadcastMessage(LanguageManager.GetText("admin.allDisposed"));
					}
					else if (args[1].equalsIgnoreCase("disposeAltars"))
					{
						GetStructureManager().DisposeStructures();

						Bukkit.broadcastMessage(LanguageManager.GetText("admin.altarsDisposed"));
					}
					else if (args[1].equalsIgnoreCase("disposeCauldrons"))
					{
						GetBrewingManager().DisposeStructures();

						Bukkit.broadcastMessage(LanguageManager.GetText("admin.cauldronsDisposed"));
					}
					else if (args[1].equalsIgnoreCase("deleteRecipe"))
					{
						if (args.length < 3)
						{
							sender.sendMessage(LanguageManager.GetText("tooFewParams"));

							return true;
						}

						try
						{
							IRecipeManager manager = GetRecipeManager();

							//if (manager instanceof IIDRecipeManager)
							//{
								try
								{
									if (GetRecipeManager().DeleteRecipe(Integer.parseInt(args[2])))
									{
										sender.sendMessage(LanguageManager.GetText("admin.recipeDeleted"));
									}
									else
									{
										sender.sendMessage(LanguageManager.GetText("admin.recipeCannotBeDeleted"));
									}
								}
								catch (ClassCastException ex)
								{
									sender.sendMessage(
											LanguageManager.GetText("admin.recipeManagerIDTypeNotSupported"));
								}
							//}
							//else
							//{
							//	sender.sendMessage(LanguageManager.GetText("admin.recipeManagerIDNotSupported"));
							//}
						}
						catch (NumberFormatException ex)
						{
							sender.sendMessage(LanguageManager.GetText("onlyNumberAccepted"));
						}
					}
					else if (args[1].equalsIgnoreCase("save"))
					{
						if (GetRecipeManager() instanceof FileRecipeManager)
						{
							if (((FileRecipeManager) GetRecipeManager()).SaveRecipes())
							{
								sender.sendMessage(LanguageManager.GetText("admin.recipesSaved"));
							}
							else
							{
								sender.sendMessage(LanguageManager.GetText("admin.recipesNotSaved"));
							}
						}
						else
						{
							sender.sendMessage(LanguageManager.GetText("admin.recipeStorageDoesntSupportSaving"));
						}
					}
					else if(args[1].equalsIgnoreCase("altarCreate") && args.length > 2)
					{
						int level = Integer.parseInt(args[2]);
						
						Location origin = ((Player)sender).getLocation().add(0, -1, 0).getBlock().getLocation();
						
						boolean toggler = true;
						for(int i = -level; i <= level; i++)
						{
							for(int j = -level; j <= level; j++)
							{
								origin.clone().add(i, 0, j).getBlock().setType(toggler ? Material.DIAMOND_BLOCK : Material.EMERALD_BLOCK);
								
								toggler = !toggler;
							}
						}
						
						origin.clone().getBlock().setType(Material.REDSTONE_BLOCK);
						
						origin.add(0, 0, -level - 1).getBlock().setType(Material.REDSTONE_BLOCK);
					}

					return true;
				}
			}

			if (!(sender instanceof Player))
			{
				sender.sendMessage(LanguageManager.GetText("onlyPlayersCanExecute"));

				return true;
			}

			Player p = (Player) sender;

			if (args[0].equalsIgnoreCase("admin"))
			{
				if (!sender.hasPermission("magicAspect.crafting.admin.panel"))
				{
					sender.sendMessage(LanguageManager.GetText("noPermission"));

					return true;
				}

				ICreationHandler<Test> h = new ICreationHandler<Test>()
				{
					@Override
					public void onCreationHandle(
							ICreationInterface<Test> creationInterface)
					{
						Bukkit.getLogger().info("IT IS DONE!");
						Bukkit.getLogger().info(creationInterface.Return().toString());
					}

					@Override
					public void onErrorHandle(
							ICreationInterface<Test> creationInterface, int code)
					{
						// TODO Auto-generated method stub
						
					}
				};
				
				CreationMenuSession<Test> cms = new CreationMenuSession<Test>(((Player)sender).getUniqueId(), this.GetSessionManager(), CreationMenu.instance, Test.class, h);
				
				cms.Open();
				//SiteMenuInventorySession<CreationMenu, SiteSession> amS = new SiteMenuInventorySession<AdminMenu, SiteSession>(((Player)sender).getUniqueId(), inventorySessionManager, adminMenu);
				
				//inventorySessionManager.InsertSession(amS);
				
				//amS.Open();
				
				return true;
			}
			else if (args[0].equalsIgnoreCase("creator"))
			{
				if (!sender.hasPermission("magicAspect.crafting.admin.recipeCreatorAltarCreate"))
				{
					sender.sendMessage(LanguageManager.GetText("noPermission"));

					return true;
				}

				if (args.length == 1)//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! && altarManager.HasModifierStruct(p.getUniqueId()))
				{
					if (!sender.hasPermission("magicAspect.crafting.admin.panel"))
					{
						sender.sendMessage(LanguageManager.GetText("noPermission"));

						return true;
					}

					/*AdminMenuSession amS = new AdminMenuSession(adminMenu.CreateSession(), ((Player)sender).getUniqueId(), adminMenu, 2);
					MenuManager.GetInstance().InsertSession(amS);
					
					amS.Open();*/

					return true;
				}

				if (structureManager.GetStructure(p.getLocation().clone().add(0, -1, 0)) != null)
				{
					sender.sendMessage(LanguageManager.GetText("recipeCreatorStructure.structureAlreadyExists"));

					return true;
				}

				sender.sendMessage(
						LanguageManager.GetText("recipeCreatorStructure.onlyOneRecipeCreatorStructureAllowed"));

				return true;
			}
			else if (args[0].equalsIgnoreCase("destroy"))
			{
				IStructure as = structureManager.GetStructure(p.getLocation().clone().add(0, -1, 0));

				if (as != null)
				{
					if (!p.hasPermission("magicAspect.crafting.bypassOwnership")
							&& (Main.GetInstance().GetConfigManager().isAltarOwnershipChecking()
									&& !p.getUniqueId().equals(as.GetOwner())))
					{
						p.sendMessage(LanguageManager.GetText("noOwnership"));

						return true;
					}

					structureManager.RemoveStructure(as);

					// p.sendMessage(LanguageManager.GetText(as instanceof
					// RecipeCreatorStructure
					// ? "recipeCreatorStructure.destroyed" :
					// "altar.destroyed"));
				}
				else
				{
					p.sendMessage(LanguageManager.GetText("altar.notExists"));
				}

				return true;
			}
		}

		return true;
	}
}
