package an0nym8us.bukkit.magicCrafting;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Dye;

public class ISBuilder
{
	protected static Class<?> _nbtTagCompound;
	protected static Class<?> _itemStack;
	protected static Class<?> _craftItemStack;
	protected static Class<?> _nbtCompressedStreamTools;

	protected static Class<?> _item;
	protected static Class<?> _minecraftKey;
	protected static Class<?> _registryMaterials;

	protected static Constructor<?> _mK_C_String;
	protected static Method _rM_get;
	protected static Method _rM_a;
	protected static Method _rM_b;
	protected static Method _rM_iterator;

	protected static Method _cIS_asNMSCopy;
	protected static Method _cIS_asBukkitCopy;
	protected static Method _iS_save;
	protected static Method _iS_createStack;
	protected static Method _nCST_a_i;
	protected static Method _nCST_a_o;

	static
	{
		try
		{
			_nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagCompound");
			_itemStack = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".ItemStack");
			_craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + NMSProvider.GetNMSVersion() + ".inventory.CraftItemStack");
			_nbtCompressedStreamTools = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTCompressedStreamTools");

			_item = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".Item");
			_minecraftKey = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".MinecraftKey");
			_registryMaterials = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".RegistryMaterials");

			_mK_C_String = _minecraftKey.getDeclaredConstructor(String.class);
			_mK_C_String.setAccessible(true);
			_rM_get = NMSProvider.GetMethod(_registryMaterials, "get", Object.class);
			_rM_get.setAccessible(true);
			_rM_a = NMSProvider.GetMethod(_registryMaterials, "a", Object.class);
			_rM_a.setAccessible(true);
			_rM_b = NMSProvider.GetMethod(_registryMaterials, "b", Object.class);
			_rM_b.setAccessible(true);
			_rM_iterator = NMSProvider.GetMethod(_registryMaterials, "iterator");
			_rM_iterator.setAccessible(true);

			_cIS_asNMSCopy = NMSProvider.GetMethod(_craftItemStack, "asNMSCopy", ItemStack.class);
			_cIS_asBukkitCopy = NMSProvider.GetMethod(_craftItemStack, "asBukkitCopy", _itemStack);
			_iS_save = NMSProvider.GetMethod(_itemStack, "save", _nbtTagCompound);
			_iS_createStack = NMSProvider.GetMethod(_itemStack, "createStack", _nbtTagCompound);
			_nCST_a_i = _nbtCompressedStreamTools.getDeclaredMethod("a", InputStream.class);
			_nCST_a_o = _nbtCompressedStreamTools.getDeclaredMethod("a", _nbtTagCompound, OutputStream.class);

			_nCST_a_i.setAccessible(true);
			_nCST_a_o.setAccessible(true);
		}
		catch (ClassNotFoundException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}
	}

	ItemStack result;

	ISBuilder()
	{
	}

	public ISBuilder(ItemStack is)
	{
		if (!is.hasItemMeta())
		{
			is.setItemMeta(Bukkit.getItemFactory().getItemMeta(is.getType()));
		}

		this.result = is;
	}
	
	public static ItemStack[] PrepareEmptyArray(int size)
	{
		if(size < 0) { return null; }
		
		ItemStack[] res = new ItemStack[size];
		
		for(int i = 0; i < size; i++)
		{
			res[i] = new ItemStack(Material.AIR);
		}
		
		return res;
	}
	
	@SuppressWarnings("deprecation")
	public static Material GetByMCID(String mcID)
	{
		try
		{
			Object mK = _mK_C_String.newInstance(mcID);

			Field field = _item.getDeclaredField("REGISTRY");

			Object rM = field.get(null);

			Object item = _rM_get.invoke(rM, mK);

			int id = (int) _rM_a.invoke(rM, item);

			return Material.getMaterial(id);
		}
		catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
				| NoSuchFieldException | SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}

	public static String GetMCID(Material material)
	{
		try
		{
			Field field = _item.getDeclaredField("REGISTRY");
			Object rM = field.get(null);

			Iterator<Object> iterator = (Iterator<Object>) _rM_iterator.invoke(rM);

			while (iterator.hasNext())
			{
				Object obj = iterator.next();

				int id = (int) _rM_a.invoke(rM, obj);

				if (material.getId() == id)
				{
					Object mK = _rM_b.invoke(rM, obj);

					return mK.toString();
				}
			}
		}
		catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | NoSuchFieldException
				| SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}

	public static ItemStack Create(Material mat)
	{
		return new ItemStack(mat);
	}

	public ISBuilder AddParameter(String code, String value)
	{
		String[] ar = value.split("(?<=\\G.{700})");

		for (int i = 0; i < ar.length; i++)
		{
			ar[i] = ChatColor.MAGIC + "+" + code + Integer.toString(i) + '-' + ar[i];
		}

		this.AddLoreLine(ar);

		return this;
	}

	public ISBuilder RemoveParameter(String code)
	{
		this.result = ISBuilder.RemoveParameter(result, code);

		return this;
	}

	public String GetParameter(String code)
	{
		return GetParameter(result, code);
	}

	public static String GetParameter(ItemStack is, String code)
	{
		if (!is.hasItemMeta() || !is.getItemMeta().hasLore()) { return null; }

		HashMap<Integer, String> map = new HashMap<Integer, String>();

		for (String s : is.getItemMeta().getLore())
		{
			if (s.startsWith(ChatColor.MAGIC + "+" + code))
			{
				try
				{
					String[] ar = s.substring(code.length() + 3, s.length()).split("\\-");
					map.put(Integer.parseInt(ar[0]), ar[1]);
				}
				catch (NumberFormatException ex)
				{
					continue;
				}
				catch (IndexOutOfBoundsException ex)
				{
					continue;
				}
			}
		}

		if (map.size() == 0) { return null; }

		StringBuilder preRes = new StringBuilder();

		for (int i = 0; i < map.size(); i++)
		{
			if (!map.containsKey(i)) { return null; }

			preRes.append(map.get(i));
		}

		return preRes.toString();
	}

	public static boolean HasParameter(ItemStack is, String code)
	{
		return GetParameter(is, code) != null;
	}

	public static ItemStack RemoveParameter(ItemStack is, String code)
	{
		if (!is.hasItemMeta() || !is.getItemMeta().hasLore()) { return is; }

		ItemMeta im = is.getItemMeta();
		List<String> lore = is.getItemMeta().getLore();

		for (int i = 0; i < lore.size(); i++)
		{
			if (lore.get(i).startsWith(ChatColor.MAGIC + "+" + code))
			{
				lore.remove(i--);
			}
		}

		im.setLore(lore);
		is.setItemMeta(im);

		return is;
	}

	public ItemStack GetResult()
	{
		return result;
	}

	public static ISBuilder CreateIS(Material mat)
	{
		ISBuilder instance = new ISBuilder();

		instance.result = new ItemStack(mat, 1);

		instance.result.setItemMeta(Bukkit.getItemFactory().getItemMeta(instance.result.getType()));

		return instance;
	}

	public static ISBuilder CreateIS(Material mat, int amount)
	{
		ISBuilder instance = new ISBuilder();

		instance.result = new ItemStack(mat, amount);

		instance.result.setItemMeta(Bukkit.getItemFactory().getItemMeta(instance.result.getType()));

		return instance;
	}

	public static ISBuilder CreateIS(Material mat, int amount, byte data)
	{
		ISBuilder instance = new ISBuilder();

		instance.result = new ItemStack(mat, amount, data);

		instance.result.setItemMeta(Bukkit.getItemFactory().getItemMeta(instance.result.getType()));

		return instance;
	}

	public ISBuilder SetName(String name)
	{
		ItemMeta im = result.getItemMeta();
		im.setDisplayName(name);
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder AddLoreLine(String... line)
	{
		ItemMeta im = result.getItemMeta();
		List<String> lore = im.getLore() == null ? new ArrayList<String>() : im.getLore();

		for (String s : line)
		{
			lore.add(s);
		}

		im.setLore(lore);
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder AddLoreLine(List<String> list)
	{
		return AddLoreLine(list.toArray(new String[list.size()]));
	}

	public ISBuilder SetLore(String... ar)
	{
		ItemMeta im = result.getItemMeta();
		im.setLore(new ArrayList<String>(Arrays.asList(ar)));
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder SetLore(List<String> list)
	{
		ItemMeta im = result.getItemMeta();
		im.setLore(list);
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder RemoveLastLoreLine()
	{
		return RemoveLoreLine(result.getItemMeta().getLore().size() - 1);
	}

	public ISBuilder RemoveLoreLine(int index)
	{
		ItemMeta im = result.getItemMeta();

		List<String> lore = im.getLore();
		lore.remove(index);
		im.setLore(lore);
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder ClearLore()
	{
		ItemMeta im = result.getItemMeta();

		im.setLore(new ArrayList<String>());
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder SetLoreLine(int index, String line)
	{
		ItemMeta im = result.getItemMeta();

		List<String> lore = im.getLore();
		lore.set(index, line);
		im.setLore(lore);
		result.setItemMeta(im);

		return this;
	}

	public ISBuilder AddEnchantment(Enchantment ench, int level)
	{
		result.addUnsafeEnchantment(ench, level);

		return this;
	}

	public ISBuilder RemoveEnchantment(Enchantment ench)
	{
		result.removeEnchantment(ench);

		return this;
	}

	public ISBuilder SetDroppable()
	{
		if (result.getItemMeta() != null && result.getItemMeta().getLore() != null)
		{
			List<String> lore = result.getItemMeta().getLore();
			lore.add("+drop");
			ItemMeta im = result.getItemMeta();
			im.setLore(lore);
			result.setItemMeta(im);
		}
		else
		{
			List<String> lore = new ArrayList<String>();
			lore.add("+drop");
			ItemMeta im = result.getItemMeta();
			im.setLore(lore);
			result.setItemMeta(im);
		}

		return this;
	}

	public static ISBuilder CreateDyeItemStack(DyeColor dyeColor)
	{
		ISBuilder instance = new ISBuilder();

		Dye dye = new Dye();
		dye.setColor(dyeColor);
		@SuppressWarnings("deprecation")
		ItemStack res = new ItemStack(Material.INK_SACK, 1, dyeColor.getDyeData());

		instance.result = res;

		instance.result.setItemMeta(Bukkit.getItemFactory().getItemMeta(instance.result.getType()));

		return instance;
	}

	public boolean Contains(List<String> lore, String line)
	{
		for (String s : lore)
		{
			if (s.equals(line)) { return true; }
		}

		return false;
	}

	public ISBuilder AddGlow()
	{
		try
		{
			Class<?> _itemStack = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".ItemStack");
			Class<?> _craftItemStack = NMSProvider
					.GetClass("org.bukkit.craftbukkit." + Main.GetNmsVersion() + ".inventory.CraftItemStack");
			Class<?> _nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagCompound");
			Class<?> _nbtTagList = NMSProvider.GetClass("net.minecraft.server." + Main.GetNmsVersion() + ".NBTTagList");

			Object nmsStack = _craftItemStack.getDeclaredMethod("asNMSCopy", result.getClass()).invoke(null, result);

			Object tag = null;

			if (!(boolean) _itemStack.getDeclaredMethod("hasTag").invoke(nmsStack))
			{
				tag = _nbtTagCompound.newInstance();

				_itemStack.getDeclaredMethod("setTag", _nbtTagCompound).invoke(nmsStack, tag);
			}

			if (tag == null)
			{
				tag = _itemStack.getDeclaredMethod("getTag").invoke(nmsStack);
			}

			Object ench = _nbtTagList.newInstance();
			_nbtTagCompound.getDeclaredMethod("set", String.class, _nbtTagList).invoke(tag, "ench", ench);

			_itemStack.getDeclaredMethod("setTag", _nbtTagCompound).invoke(nmsStack, tag);

			result = (ItemStack) _craftItemStack.getDeclaredMethod("asCraftMirror", _itemStack).invoke(null, nmsStack);

		}
		catch (ClassNotFoundException | InstantiationException | IllegalAccessException | IllegalArgumentException
				| InvocationTargetException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}

		return this;
	}

	public static final Object SerializeIS(ItemStack itemStack)
	{
		try
		{
			Object _itemStackCIS = _cIS_asNMSCopy.invoke(null, itemStack);

			Object nbtTagCompound = _nbtTagCompound.newInstance();

			nbtTagCompound = _iS_save.invoke(_itemStackCIS, nbtTagCompound);

			return nbtTagCompound;
		}
		catch (IllegalAccessException | InvocationTargetException | SecurityException | InstantiationException ex)
		{
			ex.printStackTrace();
		}

		return false;
	}

	public static ItemStack DeserializeIS(Object nbtBase)
	{
		try
		{
			Object _is = _iS_createStack.invoke(null, nbtBase);
			ItemStack res = (ItemStack) _cIS_asBukkitCopy.invoke(null, _is);

			return res;
		}
		catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	public static boolean SerializeIS(ItemStack is, OutputStream os)
	{
		try
		{
			Object tag = _nbtTagCompound.newInstance();

			tag = _iS_save.invoke(_cIS_asNMSCopy.invoke(null, is), tag);

			_nCST_a_o.invoke(null, tag, os);

			return true;
		}
		catch (InstantiationException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return false;
	}

	public static ItemStack DeserializeIS(InputStream is)
	{
		try
		{
			Object tag = _nCST_a_i.invoke(null, is);

			ItemStack res = (ItemStack) _cIS_asBukkitCopy.invoke(null, _iS_createStack.invoke(null, tag));

			return res;
		}
		catch (IllegalAccessException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (InvocationTargetException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		catch (SecurityException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return null;
	}

	public static final Object[] SerializeIS(ItemStack[] itemStacks)
	{
		try
		{
			Object[] nbtTagCompounds = new Object[itemStacks.length];

			for (int i = 0; i < nbtTagCompounds.length; i++)
			{
				Object _itemStackCIS = _cIS_asNMSCopy.invoke(null, itemStacks[i]);

				nbtTagCompounds[i] = _nbtTagCompound.newInstance();

				nbtTagCompounds[i] = _iS_save.invoke(_itemStackCIS, nbtTagCompounds[i]);
			}

			return nbtTagCompounds;
		}
		catch (IllegalAccessException | InvocationTargetException | SecurityException | InstantiationException ex)
		{
			ex.printStackTrace();
		}

		return null;
	}

	public static ItemStack[] DeserializeIS(Object[] nbtBases)
	{
		try
		{
			ItemStack[] res = new ItemStack[nbtBases.length];

			for (int i = 0; i < res.length; i++)
			{
				Object _is = _iS_createStack.invoke(null, nbtBases[i]);
				res[i] = (ItemStack) _cIS_asBukkitCopy.invoke(null, _is);
			}

			return res;
		}
		catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
		{
			e.printStackTrace();
		}

		return null;
	}
}
