package an0nym8us.bukkit.magicCrafting;

import org.bukkit.Material;
import org.bukkit.block.Block;

public class FormationDetector
{
    Material[][][] array;

    public FormationDetector(Material[][][] array)
    {
        this.array = array;
    }

    public int[] Check(Block nat)
    {
        if (nat == null) { return null; }

        for (int i = 0; i < array.length; i++)
        {
            for (int j = 0; j < array[i].length; j++)
            {
                for (int k = 0; k < array[i][j].length; k++)
                {
                    if ((array[i][j][k] == null || nat.getType().equals(array[i][j][k])) && Check(nat, i, j, k))
                    {
                    	return new int[] { i, j, k };
                    }
                }
            }
        }

        return null;
    }

    private boolean Check(Block nat, int xOffset, int yOffset, int zOffset)
    {
        for (int i = 0; i < array.length; i++)
        {
            for (int j = 0; j < array[i].length; j++)
            {
                for (int k = 0; k < array[i][j].length; k++)
                {
                    if (array[i][j][k] != null && !nat.getRelative(i - xOffset, j - yOffset, k - zOffset)
                                    .getType().equals(array[i][j][k])) { return false; }
                }
            }
        }

        return true;
    }
}