package an0nym8us.bukkit.magicCrafting;

import java.util.Collection;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers.Particle;

public class EffectPlayer
{
	/*public static void PlayVisualEffect(int particleID, Location loc, float partData)
	{
		PlayVisualEffect(particleID, loc, new Vector(0.0, 0.0, 0.0), partData, 1);
	}*/
	
	public static void PlayVisualEffect(int particleID, World world, Vector loc, Vector offset, float partData, int partCount)
	{
		PlayVisualEffect(particleID, world, (float)loc.getX(), (float)loc.getY(), (float)loc.getZ(), offset, partData, partCount);
	}

	public static void PlayVisualEffect(int particleID, World world, double x, double y, double z, Vector offset, float partData, int partCount)
	{
		PlayVisualEffect(particleID, world, (float)x, (float)y, (float)z, offset, partData, partCount);
	}
	
	public static void PlayVisualEffect(int particleID, World world, float x, float y, float z, Vector offset, float partData, int partCount)
	{
		Collection<? extends Player> players = Bukkit.getOnlinePlayers();

		synchronized (players)
		{
			for (Player p : players)
			{
				try
				{
					if (!p.getWorld().equals(world))
					{
						continue;
					}

					PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.WORLD_PARTICLES);
					packetContainer.getModifier().writeDefaults();
					packetContainer.getParticles().write(0, Particle.getById(particleID));
					packetContainer.getFloat().write(0, x);
					packetContainer.getFloat().write(1, y);
					packetContainer.getFloat().write(2, z);
					packetContainer.getFloat().write(3, (float) offset.getX());
					packetContainer.getFloat().write(4, (float) offset.getY());
					packetContainer.getFloat().write(5, (float) offset.getZ());
					packetContainer.getFloat().write(6, partData);
					packetContainer.getIntegers().write(0, partCount);
					packetContainer.getBooleans().write(0, true);
					
					ProtocolLibrary.getProtocolManager().sendServerPacket(p, packetContainer);
				}
				catch (Exception ex)
				{
				}
			}
		}
	}
	
	public static void PlaySoundEffect(String soundName, Location loc, float volume, byte pitch)
	{
		Collection<? extends Player> players = Bukkit.getOnlinePlayers();

		synchronized (players)
		{
			for (Player p : players)
			{
				try
				{
					if (!p.getWorld().equals(loc.getWorld()))
					{
						continue;
					}

					PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.NAMED_SOUND_EFFECT);
					packetContainer.getModifier().writeDefaults();
					packetContainer.getStrings().write(0, soundName);
					packetContainer.getIntegers().write(0, loc.getBlockX());
					packetContainer.getIntegers().write(1, loc.getBlockY());
					packetContainer.getIntegers().write(2, loc.getBlockZ());
					packetContainer.getFloat().write(0, volume);
					packetContainer.getIntegers().write(3, (int) pitch);
					
					ProtocolLibrary.getProtocolManager().sendServerPacket(p, packetContainer);
				}
				catch (Exception ex)
				{
				}
			}
		}
	}

}
