package an0nym8us.bukkit.magicCrafting;

import org.bukkit.Location;

public enum Direction
{
	NORTH((byte)0)
	{
		public int[] GetIndex(int x, int z, int cx, int cz)
		{
			return new int[] { z - cz, x - cx };
		}
		
		public int[] GetLocXZ(int i, int j, int cx, int cz)
		{
			return new int[] { cx + j, cz + i };
		}
		
		public double[] GetIndex(double x, double z, double cx, double cz)
		{
			return new double[] { z - cz, x - cx };
		}
		
		public double[] GetLocXZ(double i, double j, double cx, double cz)
		{
			return new double[] { cx + j, cz + i };
		}
	},
	EAST((byte)1)
	{
		public int[] GetIndex(int x, int z, int cx, int cz)
		{
			return new int[] { cx - x, z - cz };
		}
		
		public int[] GetLocXZ(int i, int j, int cx, int cz)
		{
			return new int[] { cx - i, cz + j };
		}
		
		public double[] GetIndex(double x, double z, double cx, double cz)
		{
			return new double[] { cx - x, z - cz };
		}
		
		public double[] GetLocXZ(double i, double j, double cx, double cz)
		{
			return new double[] { cx - i, cz + j };
		}
	},
	SOUTH((byte)2)
	{
		public int[] GetIndex(int x, int z, int cx, int cz)
		{
			return new int[] { cz - z, cx - x };
		}
		
		public int[] GetLocXZ(int i, int j, int cx, int cz)
		{
			return new int[] { cx - j, cz - i };
		}
		
		public double[] GetIndex(double x, double z, double cx, double cz)
		{
			return new double[] { cz - z, cx - x };
		}
		
		public double[] GetLocXZ(double i, double j, double cx, double cz)
		{
			return new double[] { cx - j, cz - i };
		}
	},
	WEST((byte)3)
	{
		public int[] GetIndex(int x, int z, int cx, int cz)
		{
			return new int[] { x - cx, cz - z };
		}
		
		public int[] GetLocXZ(int i, int j, int cx, int cz)
		{
			return new int[] { cx + i, cz - j };
		}
		
		public double[] GetIndex(double x, double z, double cx, double cz)
		{
			return new double[] { x - cx, cz - z };
		}
		
		public double[] GetLocXZ(double i, double j, double cx, double cz)
		{
			return new double[] { cx + i, cz - j };
		}
	};
	
	byte id;
	
	Direction(byte id)
	{
		this.id = id;
	}
	
	public byte GetID()
	{
		return id;
	}
	
	// RETURNS { i, j }
	public abstract int[] GetIndex(int x, int z, int cx, int cz);
	
	// RETURNS { x, z }
	public abstract int[] GetLocXZ(int i, int j, int cx, int cz);
	
	// RETURNS { i, j }
	public abstract double[] GetIndex(double x, double z, double cx, double cz);
	
	// RETURNS { x, z }
	public abstract double[] GetLocXZ(double i, double j, double cx, double cz);
	
	public Location GetLoc(int i, int j, Location loc)
	{		
		int[] res = GetLocXZ(i, j, loc.getBlockX(), loc.getBlockZ());
		
		return new Location(loc.getWorld(), res[0], loc.getY(), res[1]);
	}
	
	public Location GetLoc(double i, double j, Location loc)
	{		
		double[] res = GetLocXZ(i, j, loc.getBlockX(), loc.getBlockZ());
		
		return new Location(loc.getWorld(), res[0], loc.getY(), res[1]);
	}
}
