package bomberman.android.bomberman.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import bomberman.android.bomberman.Main;
import bomberman.android.bomberman.game.nat.Element;
import bomberman.android.bomberman.game.nat.Map;

/**
 * Created by Administrator on 2015-04-27.
 */
public class GameScreen extends AbstractScreen
{
    SpriteBatch batch;

    public Texture[] txtures;
    public TextureRegion[] playerTxt;
    public TextureRegion[] brdTnT;


    Skin skin;
    Table table;

    Label lives1;
    Label lives2;
    byte moved = 0;

    TextButton throwTNT;

    public GameScreen()
    {
        // Inicjuje i importuje zasoby, tj. tekstury itd.
        txtures = new Texture[Element.Elements.values().length];

        for(Element.Elements es : Element.Elements.values())
        {
            txtures[es.id] = new Texture(Gdx.files.internal("elements\\" + es.name().toLowerCase() + ".png"));
        }

        TextureAtlas txtAtlas = new TextureAtlas("playertxt.atlas");
        playerTxt = new TextureRegion[txtAtlas.getRegions().size];

        for(int i = 0; i < playerTxt.length; i++)
        {
            playerTxt[i] = txtAtlas.getRegions().get(i);
        }

        TextureAtlas txtAtlas2 = new TextureAtlas("tnt.atlas");
        brdTnT = new TextureRegion[txtAtlas2.getRegions().size];

        for(int i = 0; i < brdTnT.length; i++)
        {
            brdTnT[i] = txtAtlas2.getRegions().get(i);
        }

        batch = new SpriteBatch();


        skin = new Skin(Gdx.files.internal("uiskin.json"));
        table = new Table(skin);

        lives1 = new Label("NaN", skin);
        lives2 = new Label("NaN", skin);

        throwTNT = new TextButton(" TNT ", skin, "button-connect");

        throwTNT.addListener(new ClickListener()
        {
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                Main.instance.socket.ThrowTNT(false);
            }
        });

        table.add("You").row();
        table.add("Lives").row();
        table.add(lives1).row();
        table.add("Enemy").row();
        table.add("Lives").row();
        table.add(lives2).row();
        table.row();
        table.add(throwTNT);

        table.setPosition(Map.XSIZE * Map.STANDARD_ELEMENT_SIZE, 0);
        table.setSize(Main.VIRTUAL_WIDTH - (Map.XSIZE * Map.STANDARD_ELEMENT_SIZE), Main.VIRTUAL_HEIGHT);

        stage.addActor(table);
    }

    /**
     * Wylicza, w którym kierunku - na podstawie współrzędnych ekranu - powinien poruszyć się gracz
     * @param x Pozycja X na ekranie
     * @param y Pozycja Y na ekranie
     * @return  Kierunek, w którym gracz ma się przemieścić
     */
    private byte _getQuarter(int x, int y)
    {
        boolean b = Main.VIRTUAL_WIDTH / Main.VIRTUAL_HEIGHT * y >= x;
        boolean c = (Main.VIRTUAL_WIDTH * (Main.VIRTUAL_HEIGHT - y)) / Main.VIRTUAL_HEIGHT >= x;

        return (byte)(b ? (c ? 3 : 2) : (c ? 4 : 1));
    }

    /**
     * Rysuje mapę
     * @param delta Czas, jaki upłynął od ostaniego renderowania w sekundach
     */
    @Override
    public void Render(float delta)
    {
        Main.instance.socket.GetMap().act();

        batch.begin();
        batch.setProjectionMatrix(camera.combined);

        Main.instance.socket.GetMap().Draw(this.batch);
        batch.end();

        lives1.setText(Byte.toString(Main.instance.socket.GetMap().GetCurrentPlayer().lives));
        lives2.setText(Byte.toString(Main.instance.socket.GetMap().GetEnemyPlayer().lives));
    }

    @Override
    public void Resize(int width, int height)
    {
        table.invalidateHierarchy();
        table.setSize(Main.VIRTUAL_WIDTH - (Map.XSIZE * Map.STANDARD_ELEMENT_SIZE), Main.VIRTUAL_HEIGHT);
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }


    public boolean touchDown(int screenX, int screenY, int pointer, int button)
    {
        // Skaluje/rzutuje współrzędne ekranu na współrzędne podlegające pod wirtualną rozdzielczość
        screenY = (int)(Main.VIRTUAL_HEIGHT - (screenY * Main.VIRTUAL_HEIGHT / Gdx.graphics.getHeight()));
        screenX = (int)(screenX * Main.VIRTUAL_WIDTH / Gdx.graphics.getWidth());

        // Jeśli pozycja X będzie większa niż szerokość mapy, nie wykonuj
        if(screenX > Map.XSIZE * Map.STANDARD_ELEMENT_SIZE) { return false; }

        byte quarter = _getQuarter(screenX, screenY);

        switch (quarter)
        {
            case 2:
                quarter = (byte)0;
                break;
            case 4:
                quarter = (byte)2;
                break;
        }

        // Porusza gracza w danym kierunku
        Main.instance.socket.GetMap().GetCurrentPlayer().Move(quarter);

        return false;
    }

    public void SetLives(int lives1, int lives2)
    {
        // Ustawia ilość żyć gracza
        Main.instance.game.lives1.setText(Byte.toString(Main.instance.socket.GetMap().GetCurrentPlayer().lives));
        Main.instance.game.lives2.setText(Byte.toString(Main.instance.socket.GetMap().GetEnemyPlayer().lives));
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button)
    {
        // Jeśli gracz przestanie przytrzymywać przycisk, przestań się poruszać
        Main.instance.socket.GetMap().GetCurrentPlayer().StopMove();
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer)
    {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void pause() {

    }

    @Override
    public void resume() {

    }

    @Override
    public void hide() {

    }

    @Override
    public void dispose() {

    }
}
