package bomberman.android.bomberman.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;

import bomberman.android.bomberman.Main;

/**
 * Created by Administrator on 2015-05-04.
 */
public class EndScreen extends AbstractScreen
{
    public static final int VISIBILITY_TIME = 192;

    Skin skin;
    Label label;
    Table table;

    int time;

    public EndScreen()
    {
        Skin skin = new Skin(Gdx.files.internal("uiskin.json"));
        label = new Label("PRZEGRANA", skin, "label-end");
        table = new Table();
        table.setBounds(0, 0, Main.VIRTUAL_WIDTH, Main.VIRTUAL_HEIGHT);

        table.add(label);

        stage.addActor(table);
    }

    /**
     * Metoda wyświetlająca ten panel na ekranie, z odpowiednio ustawionym teksten
     * @param text  Tekst do wyświetlenia
     */
    public void Show(String text) // FALSE - LOSE, TRUE - WIN
    {
        // Ustawia tekst etykiety na podany
        label.setText(text);

        time = VISIBILITY_TIME;

        Main.instance.set(this);
    }

    @Override
    public void Render(float delta)
    {
        if(time > 0)
        {
            // Jeśli czas wyświetlania tego panelu się skończył, zmień wyświetlany panel na menu
            if(time == 1)
            {
                Main.instance.set(Main.instance.basic);
            }

            time--;
        }
    }

    @Override
    public void Resize(int width, int height) {

    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void pause() {

    }

    @Override
    public void resume() {

    }

    @Override
    public void hide() {

    }

    @Override
    public void dispose() {

    }
}
