package bomberman.android.bomberman.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import bomberman.android.bomberman.DeviceWrapper;
import bomberman.android.bomberman.Main;
import bomberman.android.bomberman.game.Client;

/**
 * Created by Administrator on 2015-04-27.
 */
public class ClientScreen extends AbstractScreen
{
    Skin skin;
    Table table;

    List list;
    ScrollPane scrollPane;

    TextButton connectTo;
    TextButton scan;
    TextButton leave;

    Runnable refresh;

    public ClientScreen()
    {
        // Inicjuje i importuje zasoby, tj. tekstury itd.
        skin = new Skin(Gdx.files.internal("uiskin.json"));

        table = new Table(skin);
        table.setBounds(0, 0, Main.VIRTUAL_WIDTH, Main.VIRTUAL_HEIGHT);

        list = new List(skin);

        scrollPane = new ScrollPane(list, skin);


        connectTo = new TextButton("Connect", skin, "button-connect");
        leave = new TextButton("Leave", skin, "button-connect");
        scan = new TextButton("Scan area", skin, "button-connect");

        connectTo.addListener(new ClickListener()
        {
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                onConnectToClick(event, x, y);
            }
        });

        leave.addListener(new ClickListener()
        {
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                Main.instance.set(Main.instance.basic);
            }
        });

        scan.addListener(new ClickListener()
        {
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                scheduler.schedule(refresh, 10, TimeUnit.MILLISECONDS);
            }
        });


        table.add("Choose Host").row();
        table.add(scrollPane);
        table.add(connectTo);
        table.add(scan);
        table.add(leave);


        stage.addActor(table);


        // Tworzy obiekt wątku skanującego w posz. urządzeń
        refresh = new Runnable()
        {
            @Override
            public void run() {
                Main.instance.cpInterface.ClearDeviceList();
                scan.setText("Scanning...");
                Main.instance.cpInterface.SetDiscovery(true);

                try {
                    Thread.currentThread().sleep(3500);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                Main.instance.cpInterface.SetDiscovery(false);

                String[] items = new String[Main.instance.cpInterface.GetDeviceList().size()];

                for (int i = 0; i < items.length; i++) {
                    items[i] = Main.instance.cpInterface.GetDeviceList().get(i).name == null ? "Null-name" : Main.instance.cpInterface.GetDeviceList().get(i).name;
                }

                list.setItems((Object[])items);
                scan.setText("Scan area");
            }
        };
    }

    @Override
    public void Render(float delta) { }

    @Override
    public void Resize(int width, int height) { }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void show()
    {
        Main.instance.socket = new Client();
        super.show();
    }

    @Override
    public void pause() {

    }

    @Override
    public void resume() {

    }

    @Override
    public void hide()
    {

    }

    @Override
    public void dispose() {

    }

    /**
     * Metoda łącząca z urządzeniem wybranym z listy, wywoływana po naciśnięciu przycisku "CONNECT"
     * @param event Obiekt InputEvent
     * @param x     Pozycja X na ekranie
     * @param y     Pozycja Y na ekranie
     */
    protected void onConnectToClick(InputEvent event, float x, float y)
    {
        // Jeśli udało się połączyć, wyświetl panel gry na ekranie
        if(_connect())
        {
            Main.instance.set(Main.instance.game);
        }
    }

    /**
     * Właściwa metoda łącząca z urządzeniem BT
     * @return FALSE - nie udało się połączyć, TRUE - nawiązano połączenie
     */
    boolean _connect()
    {
        try {
            java.util.List<DeviceWrapper> l = Main.instance.cpInterface.GetDeviceList();

            for (DeviceWrapper dw : Main.instance.cpInterface.GetDeviceList()) {
                if (dw.name.equals(list.getSelected())) { // Jeśli nazwa urządzenia zgadza się z podaną, spróbuj się połączyć, jeśli się uda zwróć true
                    ((Client) Main.instance.socket).Connect(dw.mac);
                    return true;
                }
            }
        }
        catch(Exception ex) { }

        // Jeśli połączenie się nie udało, zwróć false
        return false;
    }
}
