package bomberman.android.bomberman.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

import bomberman.android.bomberman.Main;

/**
 * Created by Administrator on 2015-04-27.
 */
public class BasicScreen extends AbstractScreen
{
    public class RainbowLabel extends Label
    {
        float r = 255.f, g = 0.f, b = 0.f;

        int st = 0;

        public RainbowLabel(CharSequence text, Skin skin, String style)
        {
            super(text, skin, style);
        }

        /**
         * Metoda aktualizująca kolor etykiety
         * @param delta Czas jaki upłynął od ostatniej aktualizacji w sekundach
         */
        @Override
        public void act(float delta)
        {
            switch(st)
            {
                case 0:
                    g += 5f;

                    if(g >= 255.f) { st = 1; }
                    break;
                case 1:
                    r -= 5f;

                    if(r <= 0.f) { st = 2; }
                    break;
                case 2:
                    b += 5f;

                    if(b >= 255.f) { st = 3; }
                    break;
                case 3:
                    g -= 5f;

                    if(g <= 0.f) { st = 4; }
                    break;
                case 4:
                    r += 5f;

                    if(r >= 255.f) { st = 5; }
                    break;
                case 5:
                    b -= 5f;

                    if(b <= 9.f) { st = 0; }
                    break;
            }



            ((LabelStyle)skin.get("label-title", LabelStyle.class)).fontColor = new Color(r / 255.f, g / 255.f, b / 255.f, 1);

            super.act(delta);
        }
    }

    Skin skin;

    BitmapFont menuFont;

    RainbowLabel title;
    TextButton  connectButton;
    TextButton  hostButton;

    public BasicScreen()
    {
        // Tworzy i importuje obiekty tekstur itd.
        skin = new Skin(Gdx.files.internal("uiskin.json"));

        title = new RainbowLabel("BOMBERMAN", skin, "label-title");
        connectButton = new TextButton("CONNECT TO HOST", skin, "button-connect");
        hostButton = new TextButton("BECOME HOST", skin, "button-connect");

        title.setPosition((Main.VIRTUAL_WIDTH - title.getWidth()) / 2, Main.VIRTUAL_HEIGHT - title.getHeight());
        connectButton.setPosition((Main.VIRTUAL_WIDTH - connectButton.getWidth()) / 2, Main.VIRTUAL_HEIGHT * 0.4f);
        hostButton.setPosition((Main.VIRTUAL_WIDTH - hostButton.getWidth()) / 2, Main.VIRTUAL_HEIGHT * 0.4f - connectButton.getHeight() - 10.f);

        connectButton.addListener(new ClickListener(){
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                Main.instance.set(Main.instance.clientScreen);
            }
        });

        hostButton.addListener(new ClickListener(){
            @Override
            public void clicked(InputEvent event, float x, float y)
            {
                Main.instance.set(Main.instance.serverScreen);
            }
        });

        stage.addActor(title);
        stage.addActor(connectButton);
        stage.addActor(hostButton);
    }

    @Override
    public void show()
    {
        // Resetuje połączenie i zwalnia niektóre zasoby
        Main.instance.cpInterface.ResetConnection();
        Main.instance.socket.Dispose();
        Main.instance.socket = null;
    }

    @Override
    public void Render(float delta)
    {

    }

    @Override
    public void Resize(int width, int height) {

    }

    @Override
    public boolean keyDown(int keycode) { return false; }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }

    @Override
    public void pause() {

    }

    @Override
    public void resume() {

    }

    @Override
    public void hide() {

    }

    @Override
    public void dispose() {

    }
}
