package bomberman.android.bomberman.screens;

        import com.badlogic.gdx.Gdx;
        import com.badlogic.gdx.InputProcessor;
        import com.badlogic.gdx.Screen;
        import com.badlogic.gdx.graphics.Camera;
        import com.badlogic.gdx.graphics.GL20;
        import com.badlogic.gdx.graphics.OrthographicCamera;
        import com.badlogic.gdx.math.Rectangle;
        import com.badlogic.gdx.scenes.scene2d.Stage;

        import bomberman.android.bomberman.Main;

public abstract class AbstractScreen implements Screen, InputProcessor
{
    public Stage stage;

    Camera camera;
    Rectangle viewport;

    public AbstractScreen()
    {
        // Inicjuje obiekt Stage i tworzy obiekt kamery dla obsługi wirtualnej rozdzielczości
        stage = new Stage();

        camera = new OrthographicCamera(Main.VIRTUAL_WIDTH, Main.VIRTUAL_HEIGHT);
        camera.position.set(Main.VIRTUAL_WIDTH / 2, Main.VIRTUAL_HEIGHT / 2, 0);
    }

    /**
     * Metoda renderująca
     * @param delta Czas, jaki upłynął od ostaniego renderowania w sekundach
     */
    @Override
    public void render(float delta)
    {
        camera.update();

        // Czyści obszar rysowania
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT);

        // Aktualizuje i rysuje obiekt stage na ekranie
        stage.draw();
        stage.act(Gdx.graphics.getDeltaTime());


        Render(delta);
    }

    /**
     * Metoda obsługująca zmieną wymiarów ekranu
     * @param width     Nowa szerokość
     * @param height    Nowa wysokość
     */
    @Override
    public void resize(int width, int height)
    {
        // Tworzy nową kamerę
        OrthographicCamera cam = new OrthographicCamera(Main.VIRTUAL_WIDTH, Main.VIRTUAL_HEIGHT);
        cam.position.set(Main.VIRTUAL_WIDTH / 2, Main.VIRTUAL_HEIGHT / 2, 0);

        stage.getViewport().setCamera(cam);
    }

    /**
     * Metoda renderująca klas dziedziczących
     * @param delta Czas, jaki upłynął od ostaniego renderowania w sekundach
     */
    public abstract void Render(float delta);

    /**
     * Metoda aktualizująca wymiary ekranu klas dziedziczących
     * @param width     Nowa szerokość
     * @param height    Nowa wysokość
     */
    public abstract void Resize(int width, int height);

    /**
     * Wyświetla ten panel na ekranie
     */
    @Override
    public void show() { }

    @Override
    public abstract boolean keyDown(int keycode);
    @Override
    public abstract boolean keyUp(int keycode);
    @Override
    public abstract boolean keyTyped(char character);
    @Override
    public abstract boolean touchDown(int screenX, int screenY, int pointer, int button);
    @Override
    public abstract boolean touchUp(int screenX, int screenY, int pointer, int button);
    @Override
    public abstract boolean touchDragged(int screenX, int screenY, int pointer);
    @Override
    public abstract boolean mouseMoved(int screenX, int screenY);
    @Override
    public abstract boolean scrolled(int amount);
}
