package bomberman.android.bomberman.game.nat;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

import bomberman.android.bomberman.Main;

/**
 * Created by Administrator on 2015-04-29.
 */
public class TNT extends Element implements Solid, Undestroyable
{
    // STATE: 0 MEANS NORMAL, 1 MEANS BURNED
    public static final byte EXPLODE_COUNTDOWN = (byte)64;
    public static final byte DISPOSE_COUNTDOWN = (byte)32;

    byte timing = EXPLODE_COUNTDOWN;
    byte lvl;
    byte dir;

    byte owner; // -1 - CURRENT, 0 - NULL, 1 - ENEMY

    public TNT() { this((byte)1); }
    public TNT(byte lvl)
    {
        this(lvl, (byte)-1, (byte)0);
    }

    public TNT(byte lvl, boolean owner)
    {
        this(lvl, (byte)-1, (byte)(owner ? 1 : -1));
    }

    private TNT(byte lvl, byte dir, byte owner) // FALSE - CURRENT, TRUE - ENEMY
    {
        super((byte)3);
        this.lvl = lvl;
        this.dir = dir;
        this.timing = EXPLODE_COUNTDOWN;

        this.owner = owner;

        this.state = (byte)0;
    }

    @Override
    public void Draw(Texture t, SpriteBatch batch, int mapX, int mapY)
    {
        if(IsBurned())
        {
            batch.draw(Main.instance.game.brdTnT[dir + 1], mapX * Main.instance.game.brdTnT[dir + 1].getRegionWidth(), mapY * Main.instance.game.brdTnT[dir + 1].getRegionHeight());
        }
        else
        {
            super.Draw(t, batch, mapX, mapY);
        }
    }

    public void act(int mapX, int mapY)
    {
        if(IsBurned())
        {
            if(lvl != 0)
            {
                int dX = (dir % 2 == 0 ? 0 : (dir > 1 ? -1 : 1));
                int dY = dir % 2 == 0 ? (dir > 1 ? -1 : 1) : 0;

                if (dir == -1) {
                    for (byte i = 0; i < 4; i++) {
                        int ddX = i % 2 == 0 ? 0 : (i > 1 ? -1 : 1);
                        int ddY = i % 2 == 0 ? (i > 1 ? -1 : 1) : 0;

                        if (Main.instance.socket.GetMap().GetBlock(mapX + ddX, mapY + ddY) == null || !(Main.instance.socket.GetMap().GetBlock(mapX + ddX, mapY + ddY) instanceof Undestroyable))
                        {
                            Main.instance.socket.GetMap().SetBlock(mapX + ddX, mapY + ddY, CreatePrimedTNT((byte) (lvl - 1), i));
                        }
                    }
                } else if ((Main.instance.socket.GetMap().GetBlock(mapX + dX, mapY + dY) == null || !(Main.instance.socket.GetMap().GetBlock(mapX + dX, mapY + dY) instanceof Undestroyable)) && lvl > 0)
                {
                    Main.instance.socket.GetMap().SetBlock(mapX + dX, mapY + dY, CreatePrimedTNT((byte) (lvl - 1), dir));
                }

                this.lvl = 0;
            }

            {
                if (Main.instance.socket.GetMap().GetCurrentPlayer().x == mapX && Main.instance.socket.GetMap().GetCurrentPlayer().y == mapY)
                {
                    Main.instance.socket.DamagePlayer(false);
                }
                else if (Main.instance.socket.GetMap().GetEnemyPlayer().x == mapX && Main.instance.socket.GetMap().GetEnemyPlayer().y == mapY)
                {
                    Main.instance.socket.DamagePlayer(true);
                }
            }
        }

        if(timing <= 0)
        {
            if(state == 0) {
                state = 1;
                timing = DISPOSE_COUNTDOWN + 1;
            }
            else
            {
                // FORCE DISPOSING
                Main.instance.socket.GetMap().SetBlock(mapX, mapY, null);
                return;
            }
        }

        timing--;
    }

    boolean IsBurned()
    {
        return state == 1;
    }

    TNT CreatePrimedTNT(byte lvl, byte dir)
    {
        TNT tnt = new TNT(lvl, dir, (byte)0);
        tnt.state = 1;
        tnt.timing = DISPOSE_COUNTDOWN + 1;

        return tnt;
    }

    @Override
    public boolean IsSolid()
    {
        return state == 0;
    }
}
