package bomberman.android.bomberman.game.nat;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

import bomberman.android.bomberman.Main;

/**
 * Created by Administrator on 2015-04-29.
 */
public class Player extends Element
{
    // state definiuje kierunek: 0 - GÓRA, 1 - PRAWO, 2 - POŁUDNIE, 3 - LEWO
    // movedPart - Od ~TIMING~ do 0, to część przebyta od lokacji początkowej do lokacji określonej przez kierunek ruchu ( jeśli zero, wtedy brak ruchu )

    public static final int TIMING = 8;
    public static final int LIVES = 3;
    public static final int LEVEL = 3;
    public static final byte TNT_IMMUNITY_PERIOD = (byte)127;
    public static final int MAX_BOMBS_PER_ONCE = 2;

    public byte movedPart, x, y, lives, lvl, immunityTime;
    boolean keepMoving;

    public Player(byte x, byte y)
    {
        super((byte)3);

        this.x = x;
        this.y = y;
        this.lives = LIVES;
        this.lvl = LEVEL;
        this.movedPart = 0;

        this.keepMoving = false;
    }

    /**
     * Sprawdza, czy na elemencie o podanych współrzędnych może stać gracz
     * @param dX    Zmiana pozycji X na mapie
     * @param dY    Zmiana pozycji Y na mapie
     * @return      FALSE - nie może, TRUE - możę
     */
    public boolean CanMove(int dX, int dY)
    {
        return Main.instance.socket.GetMap().GetBlock(x + dX, y + dY) == null || !(Main.instance.socket.GetMap().GetBlock(x + dX, y + dY).IsSolid());
    }

    /**
     * Przemieszcza gracza w podanym kierunku - METODA DO UŻYTKU OGÓLNEGO
     * @param   direction Kierunek:   0 - GÓRA, 1 - PRAWO, 2 - POŁUDNIE, 3 - LEWO
     * @return  FALSE - gracz nie może się tam przemieścić, TRUE - przemieszczanie gracza
     */
    public boolean Move(byte direction)
    {
        if(_move(direction))
        {
            Main.instance.socket.GetMap().GetCurrentPlayer().StartMove();
            Main.instance.socket.Send_PLAYER_MOVED(direction);
            return true;
        }

        return false;
    }

    /**
     * Przemieszcza gracza w podanym kierunku - METODA DO UŻYTKU TYLKO PRZEZ OBSŁUGĘ PAKIETÓW
     * @param   direction Kierunek:   0 - GÓRA, 1 - PRAWO, 2 - POŁUDNIE, 3 - LEWO
     * @return  FALSE - gracz nie może się tam przemieścić, TRUE - przemieszczanie gracza
     */
    public boolean _move(byte direction)
    {
        int dX = direction % 2 == 0 ? 0 : (direction > 1 ? -1 : 1);
        int dY = direction % 2 == 0 ? (direction > 1 ? -1 : 1) : 0;

        if(movedPart == 0 && CanMove(dX, dY))
        {
            this.state = direction;
            this.movedPart = TIMING;

            x += dX;
            y += dY;

            return true;
        }

        return false;
    }

    /**
     * Włącza poruszanie
     */
    public void StartMove()
    {
        keepMoving = true;
    }

    /**
     * Wyłącza poruszanie
     */
    public void StopMove()
    {
        keepMoving = false;
    }

    /**
     * Rysuje gracza
     * @param t     Tekstura
     * @param batch Uprzednio utworzony SpriteBatch
     */
    public void DrawPlayer(TextureRegion[] t, SpriteBatch batch)
    {
        if(movedPart == 0)
        {
            batch.draw(t[0], x * t[0].getRegionWidth(), y * t[0].getRegionHeight());
        }
        else
        {
            byte dir = this.state;
            int dX = dir % 2 == 0 ? 0 : (dir > 1 ? -1 : 1);
            int dY = dir % 2 == 0 ? (dir > 1 ? -1 : 1) : 0;

            batch.draw(t[dir + 1], (x - ((float)dX * movedPart / TIMING)) * t[dir + 1].getRegionWidth(), (y - ((float)dY * movedPart / TIMING)) * t[dir + 1].getRegionHeight());
        }
    }

    /**
     * Aktualizuje zmienne gracza
     * @param mapX  Pozycja X elementu
     * @param mapY  Pozycja Y elementu
     */
    @Override
    public void act(int mapX, int mapY)
    {
        byte dir = state;

        int dX = (dir % 2 == 0 ? 0 : (dir > 1 ? -1 : 1));
        int dY = dir % 2 == 0 ? (dir > 1 ? -1 : 1) : 0;

        if(movedPart != 0)
        {
            float fX = x - ((float)dX * movedPart / TIMING);
            float fY = y - ((float)dY * movedPart / TIMING);

            movedPart--;

            if(movedPart == 0 && keepMoving)
            {
                Move(dir);
            }
        }

        if(immunityTime > 0) { immunityTime--; }
    }
}
