package bomberman.android.bomberman.game.nat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

/*
    PROTOKÓŁ KLIENT-SERWER-KLIENT

    0x00 IDENTIFY - Sends byte array { 1, 2, 4, 7, 9 } (client to server, next and server to client)

    0x01 PLAYER_MOVED - byte direction              // INFORMUJE O RUCHU GRACZA
    0x02 TNT_THROWN - null                          // INFORMUJE O PODŁOŻENIU TNT PRZEZ GRACZA
 */
public class Packet
{
    public byte id;
    public byte[] data;

    private Packet() { }
    public Packet(byte id, byte... data)
    {
        this.id = id;
        this.data = data;
    }

    /**
     * Czyta pakiet ze strumienia
     * @param is    Strumień danych
     * @return      Odczytany pakiet
     */
    public static Packet ReadPacket(InputStream is)
    {
        try
        {
            Packet p = new Packet();
            DataInputStream dis = new DataInputStream(is);

            int length = dis.readInt();
            p.id = dis.readByte();

            p.data = new byte[length - 1];

            dis.read(p.data, 0, p.data.length);

            return p;
        }
        catch(Throwable t)
        {
            return null;
        }
    }

    /**
     * Wpisuje pakiet do stromienia
     * @param os    Strumień danych
     * @return      FALSE - nie udało się, TRUE - wpisano pomyślnie
     */
    public boolean WritePacket(OutputStream os)
    {
        try
        {
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(data.length + 1);
            dos.writeByte(id);
            dos.write(data);

            return true;
        }
        catch(Throwable t)
        {
            return false;
        }
    }
}
