package bomberman.android.bomberman.game.nat;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;

import bomberman.android.bomberman.Main;

public class Map
{
    public static int XSIZE = 13;
    public static int YSIZE = 9;
    public static int STANDARD_ELEMENT_SIZE = 80;

    private Element[][] elementMap;

    Player p1, p2;

    public Map(int x1, int y1, int x2, int y2) // DEFINES CURRENT PLAYER COORDS AND ENEMY PLAYER COORDS
    {
        elementMap = new Element[XSIZE][YSIZE];

        p1 = new Player((byte)x1, (byte)y1);
        p2 = new Player((byte)x2, (byte)y2);

        for(int i = 0; i < Map.YSIZE; i++)
        {
            SetBlock(0, i, Element.Elements.Wall.id, (byte)0);
            SetBlock(Map.XSIZE - 1, i, Element.Elements.Wall.id, (byte)0);
        }

        for(int i = 0; i < Map.XSIZE; i++)
        {
            SetBlock(i, 0, Element.Elements.Wall.id, (byte)0);
            SetBlock(i, Map.YSIZE - 1, Element.Elements.Wall.id, (byte)0);
        }

        for(int i = 2; i < Map.XSIZE - 2; i += 2)
        {
            for(int j = 2; j < Map.YSIZE - 2; j += 2)
            {
                SetBlock(i, j, Element.Elements.Wall.id, (byte)0);
            }
        }

        for(int i = 0; i < Map.XSIZE; i++)
        {
            for(int j = 0; j < Map.YSIZE; j++)
            {
                if(elementMap[i][j] == null)
                {
                    SetBlock(i, j, Element.Elements.Block.id, (byte)0);
                }
            }
        }

        elementMap[x1][y1] = null;
        elementMap[x2][y2] = null;

        for(int i = -1; i < 2; i++)
        {
            for(int j = -1; j < 2; j++)
            {
                if (!(elementMap[i + x1][j + y1] instanceof Wall))
                {
                    elementMap[i + x1][j + y1] = null;
                }
                if (!(elementMap[i + x2][j + y2] instanceof Wall))
                {
                    elementMap[i + x2][j + y2] = null;
                }
            }
        }

        elementMap[7][4] = new TNT((byte)3);
    }

    /**
     * Zwraca spakowaną mapę do byte[]
     * @return  Tablice byte[] spakowanej mapy
     * @deprecated Zaimplementowana na początku, nieużywana ze względu na strukturę protokołu
     */
    @Deprecated
    public byte[] GetRaw()
    {
        byte[] data = new byte[XSIZE * YSIZE * 2];

        for(int i = 0; i < XSIZE * YSIZE; i++)
        {
            data[i * 2] = elementMap[i % XSIZE][i / YSIZE].id;
            data[i * 2 + 1] = elementMap[i % XSIZE][i / YSIZE].state;
        }

        return data;
    }

    /**
     * Aktualizuje mapę o podaną spakowaną tablicę typu byte
     * @param data  Mapa spakowana do byte[]
     * @deprecated Zaimplementowana na początku, nieużywana ze względu na strukturę protokołu
     */
    @Deprecated
    public void UpdateMap(byte[] data)
    {
        for(int i = 0; i < XSIZE * YSIZE; i++)
        {
            elementMap[i % XSIZE][i / YSIZE] = Element.Elements.NewElement(data[i * 2]);
            elementMap[i % XSIZE][i / YSIZE].state = data[i * 2 + 1];
        }
    }

    /**
     * Podmienia element mapy na podany
     * @param x     Pozycja X na mapie
     * @param y     Pozycja Y na mapie
     * @param id    ID elementu
     * @param state Stan elementu
     */
    public void SetBlock(int x, int y, int id, int state)
    {
        elementMap[x][y] = Element.Elements.NewElement((byte)id);
        elementMap[x][y].state = (byte)state;
    }

    /**
     * Rysuje całą mapę
     * @param batch Uprzednio utworzony SpriteBatch
     */
    public void Draw(SpriteBatch batch)
    {
        Main.instance.socket.GetMap().GetCurrentPlayer().DrawPlayer(Main.instance.game.playerTxt, batch);
        Main.instance.socket.GetMap().GetEnemyPlayer().DrawPlayer(Main.instance.game.playerTxt, batch);

        for(int i = 0; i < XSIZE; i++)
        {
            for(int j = 0; j < YSIZE; j++)
            {
                if(GetBlock(i, j) == null) { continue; }
                GetBlock(i, j).Draw(Main.instance.game.txtures[GetBlock(i, j).GetID()], batch, i, j);
            }
        }
    }

    /**
     * Metoda aktualizująca mapę, wywołuje Element.act(int par1, int par2) każdego elementu i obj. graczy
     */
    public void act()
    {
        for(int i = 0; i < XSIZE; i++)
        {
            for(int j = 0; j < YSIZE; j++)
            {
                if(elementMap[i][j] == null) { continue; }
                elementMap[i][j].act(i, j);
            }
        }

        p1.act(p1.x, p1.y);
        p2.act(p2.x, p2.y);
        Main.instance.game.SetLives(p1.lives, p2.lives);
    }

    /**
     * Zwraca ilość TNT, jaką postawił dany gracz
     * @param owner FALSE - obecny gracz, TRUE - wróg
     * @return  Ilość postawionych TNT
     */
    public byte GetPlayersTNT(boolean owner)
    {
        byte amount = 0;

        for(int i = 0; i < XSIZE; i++)
        {
            for(int j = 0; j < YSIZE; j++)
            {
                if(elementMap[i][j] != null && elementMap[i][j] instanceof TNT)
                {
                    if(((TNT)elementMap[i][j]).owner == (owner ? 1 : -1))
                    {
                        amount++;
                    }
                }
            }
        }

        return amount;
    }

    /**
     * Podmienia element na podany
     * @param x Pozycja X na mapie
     * @param y Pozycja Y na mapie
     * @param e Nowy element
     */
    public void SetBlock(int x, int y, Element e)
    {
        elementMap[x][y] = e;
    }

    /**
     * Zwraca element z mapy
     * @param x Pozycja X na mapie
     * @param y Pozycja Y na mapie
     * @return  Element mapy
     */
    public Element GetBlock(int x, int y)
    {
        return elementMap[x][y];
    }

    /**
     * Zwraca obecnego gracza
     * @return  Obecny gracz
     */
    public Player GetCurrentPlayer()
    {
        return p1;
    }

    /**
     * Zwraca wrogiego gracza
     * @return  Wrogi gracz
     */
    public Player GetEnemyPlayer() { return p2; }
}
