package bomberman.android.bomberman.game.nat;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

public abstract class Element
{
    /**
     * Typ wyliczeniowy dostępnych rodzajów bloków
     */
    public enum Elements
    {
        Wall((byte)0, Wall.class),
        Block((byte)1, Block.class),
        Player((byte)2, Player.class),
        TNT((byte)3, TNT.class);

        public byte id;
        Class<? extends Element> clazz;

        Elements(byte id, Class<? extends Element> clazz)
        {
            this.id = id;
            this.clazz = clazz;
        }

        /**
         * Tworzy nowy element odpowiednio do podanego ID
         * @param id    ID elementu
         * @return      Element podanego typu
         */
        public static Element NewElement(byte id)
        {
            try
            {
                for (Elements e : Elements.values())
                {
                    if (e.id == id)
                    {
                        return e.clazz.getDeclaredConstructor((Class<?>[])null).newInstance((Object[])null);
                    }
                }
            }
            catch(Throwable t) {    }

            return null;
        }
    }
    byte state;
    byte id;

    public Element(byte id)
    {
        this(id, (byte)0);
    }

    public Element(byte id, byte state)
    {
        this.id = id; this.state = state;
    }

    /**
     * Zwraca stan obiektu
     * @param state Stan
     */
    public void SetState(byte state)
    {
        this.state = state;
    }

    /**
     * Zwraca ID obiektu
     * @return  ID obiektu
     */
    public byte GetID() { return id; }

    /**
     * Zwraca wartość okr. czy dany obiekt jest możliwy do przejścia przez gracza
     * @return  FALSE - nie, TRUE - tak
     */
    public boolean IsSolid()
    {
        return this instanceof Solid;
    }

    /**
     * Rysuje obiekt
     * @param t     Tekstura obiektu
     * @param batch Uprzednio utworzony SpriteBatch
     * @param mapX  Pozycja X na mapie
     * @param mapY  Pozycja Y na mapie
     */
    public void Draw(Texture t, SpriteBatch batch, int mapX, int mapY)
    {
        batch.draw(t, mapX * t.getWidth(), mapY * t.getHeight());
    }

    /**
     * Metoda odp. za aktualizowanie pozycji i innych wartości elementu
     * @param mapX  Pozycja X elementu
     * @param mapY  Pozycja Y elementu
     */
    public abstract void act(int mapX, int mapY);
}
