package bomberman.android.bomberman.game;

import bomberman.android.bomberman.Main;
import bomberman.android.bomberman.game.nat.Map;
import bomberman.android.bomberman.game.nat.Packet;
import bomberman.android.bomberman.game.nat.Player;
import bomberman.android.bomberman.game.nat.TNT;

public abstract class Network
{
    Map map;

    volatile Thread comThread;

    public Network(int x1, int y1, int x2, int y2)
    {
        map = new Map(x1, y1, x2, y2);

        comThread = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                comThreadMethod();
            }
        });
    }

    /**
     * Metoda wątku przechwytującego i obsługującego pakiety przychodzące
     */
    void comThreadMethod()
    {
        while(true)
        {
            try
            {
                Packet packet = Packet.ReadPacket(Main.instance.cpInterface.GetInputStream());

                // ID 0x01 - Pakiet ruchu, 0x02 - Pakiet TNT. Obsługuje przychodzące pakiety
                switch (packet.id) {
                    case 0x01:
                        int dX = packet.data[0] % 2 == 0 ? 0 : (packet.data[0] > 1 ? -1 : 1);
                        int dY = packet.data[0] % 2 == 0 ? (packet.data[0] > 1 ? -1 : 1) : 0;

                        if(map.GetEnemyPlayer().movedPart == 0) {
                            map.GetEnemyPlayer().SetState(packet.data[0]);
                        }

                        map.GetEnemyPlayer().movedPart += Player.TIMING;
                        map.GetEnemyPlayer().x += dX;
                        map.GetEnemyPlayer().y += dY;

                        break;
                    case 0x02:
                        this._throwTNT(true);
                        break;
                }
            }
            catch(Throwable t)
            {
                // Wyjątek jest zwracany wtedy, gdy zostanie zakończone połączenie
                break;
            }
        }
    }

    /**
     * Metoda stawiająca TNT w pozycji gracza - DO UŻYTKU OGÓLNEGO
     * @param owner     Właściciel TNT - FALSE - obecny gracz, TRUE - wróg
     * @return          FALSE - nie można postawić TNT, TRUE - postawiono TNT
     */
    public boolean ThrowTNT(boolean owner)
    {
        // Jeśli udało się postawić TNT, wyślij pakiet informujący o tym i zwróć true, w przeciwnym razie zwraca false
        if(_throwTNT(owner))
        {
            Main.instance.socket.Send_TNT_THROWN();

            return true;
        }

        return false;
    }

    /**
     * Metoda stawiająca TNT w pozycji gracza - DO UŻYTKU PRZEZ OBSŁUGĘ PAKIETÓW
     * @param owner     Właściciel TNT - FALSE - obecny gracz, TRUE - wróg
     * @return          FALSE - nie można postawić TNT, TRUE - postawiono TNT
     */
    public boolean _throwTNT(boolean owner)
    {
        // Jeśli gracz postawił mniej TNT niż wynosi limit, postaw TNT w jego lokalizacji i zwróć true, w przeciwnym razie zwróć false
        if(Main.instance.socket.GetMap().GetPlayersTNT(owner) < Player.MAX_BOMBS_PER_ONCE)
        {
            TNT ttt = new TNT((owner ? GetMap().GetEnemyPlayer() : GetMap().GetCurrentPlayer()).lvl, owner);
            GetMap().SetBlock((owner ? GetMap().GetEnemyPlayer() : GetMap().GetCurrentPlayer()).x, (owner ? GetMap().GetEnemyPlayer() : GetMap().GetCurrentPlayer()).y, ttt);

            return true;
        }

        return false;
    }

    /**
     * Zadaje obrażenia podanemu graczowi
     * @param st    FALSE - obecny gracz, TRUE - wróg
     */
    public void DamagePlayer(boolean st)
    {
        if(st)
        {
            // Jeśli odporność na obrażenia minęła...
            if(map.GetEnemyPlayer().immunityTime == 0)
            {
                // Jeśli wrogiemu graczowi skończtyły się życia, wyświetl ekran "WYGRANA"
                if(--map.GetEnemyPlayer().lives == 0)
                {
                    Main.instance.endScreen.Show("WYGRANA!");
                }

                map.GetEnemyPlayer().immunityTime = Player.TNT_IMMUNITY_PERIOD;
            }
        }
        else
        {
            // Jeśli odporność na obrażenia minęła...
            if(map.GetCurrentPlayer().immunityTime == 0)
            {
                // Jeśli obecnemu graczowi skończtyły się życia, wyświetl ekran "PRZEGRANA"
                if(--map.GetCurrentPlayer().lives == 0)
                {
                    Main.instance.endScreen.Show("PRZEGRANA");
                }
                map.GetCurrentPlayer().immunityTime = Player.TNT_IMMUNITY_PERIOD;
            }
        }
    }

    /**
     * Zwraca obiekt mapy
     * @return  Mapa
     */
    public Map GetMap()
    {
        return map;
    }

    /**
     * Zwalnia zasoby wątku
     */
    public void Dispose()
    {
        comThread.interrupt();
        comThread = null;
    }


    /**
     * Wysyła pakiet ruchu gracza
     * @param dir   Kierunek
     * @return      FALSE - nie udało się, TRUE - wysłano pakiet
     */
    public boolean Send_PLAYER_MOVED(byte dir)
    {
        Packet p = new Packet((byte)0x01, dir);
        return p.WritePacket(Main.instance.cpInterface.GetOutputStream());
    }

    /**
     * Wysyła pakiet postawienia TNT
     * @return      FALSE - nie udało się, TRUE - wysłano pakiet
     */
    public boolean Send_TNT_THROWN()
    {
        Packet p = new Packet((byte) 0x02);
        return p.WritePacket(Main.instance.cpInterface.GetOutputStream());
    }
}
