package bomberman.android.bomberman;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;

import bomberman.android.bomberman.game.Client;
import bomberman.android.bomberman.game.Network;
import bomberman.android.bomberman.screens.AbstractScreen;
import bomberman.android.bomberman.screens.BasicScreen;
import bomberman.android.bomberman.screens.ClientScreen;
import bomberman.android.bomberman.screens.EndScreen;
import bomberman.android.bomberman.screens.GameScreen;
import bomberman.android.bomberman.screens.ServerScreen;

public class Main extends Game
{
    public static Main instance;
    public static final float VIRTUAL_WIDTH = 1280;
    public static final float VIRTUAL_HEIGHT = 720;
    public static final float ASPECT_RATIO = VIRTUAL_WIDTH / VIRTUAL_HEIGHT;

    public CPInterface cpInterface;
    public Network socket;
	public SpriteBatch batch;

    public BasicScreen basic;
    public GameScreen game;
    public ClientScreen clientScreen;
    public ServerScreen serverScreen;
    public EndScreen endScreen;

    public Main(CPInterface cpInterface)
    {
        Main.instance = this;
        this.cpInterface = cpInterface;
    }

    /**
     * Inicjuje obiekty paneli i SpriteBatch
     */
	@Override
	public void create ()
    {
		batch = new SpriteBatch();

        socket = new Client();

        basic = new BasicScreen();
        game = new GameScreen();
        clientScreen = new ClientScreen();
        serverScreen = new ServerScreen();
        endScreen = new EndScreen();

        set(basic);
	}

    /**
     * Ustawia wyświetlany panel
     * @param screen Panel do wyświetlenia
     */
    public void set(AbstractScreen screen)
    {
        this.setScreen(screen);

        InputMultiplexer im = new InputMultiplexer();
        im.addProcessor(screen);
        im.addProcessor(screen.stage);
        Gdx.input.setInputProcessor(im);
    }
}
