package bomberman.android.bomberman;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public interface CPInterface
{
    /**
     * Zwraca listę wrapperów urządzeń
     * @return  Lista wrapperów urządzeń
     */
    public List<DeviceWrapper> GetDeviceList();

    /**
     * Łączy z urządzeniem o podanym adresie
     * @param address   Adres urządzenia BT
     * @return          FALSE - nie udało się, TRUE - nawiązano połączenie
     */
    public boolean ConnectWith(String address);

    /**
     * Czyści listę urządzeń
     */
    public void ClearDeviceList();

    /**
     * Włącza/wyłącza szukanie urządzeń
     * @param state
     */
    public void SetDiscovery(boolean state);

    /**
     * Resetuje połączenie i zwalnia niektóre zasoby
     */
    public void ResetConnection();

    /**
     * Ustawia typ połączenia
     * @param type  FALSE - klient, TRUE - serwer
     */
    public void SetConnectionType(boolean type); // FALSE - KLIENT, TRUE - SERWER

    /**
     * Zwraca strumień wejściowy danych
     * @return  Strumień gniazda
     */
    public InputStream GetInputStream();

    /**
     * Zwraca strumień wyjściowy danych
     * @return  Strumień gniazda
     */
    public OutputStream GetOutputStream();
}
